/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.FilePath;
import hudson.remoting.Channel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.dao.DataAccessException;

public class ClientAuthenticationCache
implements Serializable {
    private final FilePath store;
    private final Properties props = new Properties();

    public ClientAuthenticationCache(Channel channel) throws IOException, InterruptedException {
        this.store = (channel == null ? FilePath.localChannel : channel).call(new MasterToSlaveCallable<FilePath, IOException>(){

            @Override
            public FilePath call() throws IOException {
                File home = new File(System.getProperty("user.home"));
                File hudsonHome = new File(home, ".hudson");
                if (hudsonHome.exists()) {
                    return new FilePath(new File(hudsonHome, "cli-credentials"));
                }
                return new FilePath(new File(home, ".jenkins/cli-credentials"));
            }
        });
        if (this.store.exists()) {
            try (InputStream istream = this.store.read();){
                this.props.load(istream);
            }
        }
    }

    public Authentication get() {
        Jenkins h = Jenkins.getActiveInstance();
        Secret userName = Secret.decrypt(this.props.getProperty(this.getPropertyKey()));
        if (userName == null) {
            return Jenkins.ANONYMOUS;
        }
        try {
            UserDetails u = h.getSecurityRealm().loadUserByUsername(userName.getPlainText());
            return new UsernamePasswordAuthenticationToken((Object)u.getUsername(), (Object)"", u.getAuthorities());
        }
        catch (AuthenticationException | DataAccessException e) {
            return Jenkins.ANONYMOUS;
        }
    }

    private String getPropertyKey() {
        String url = Jenkins.getActiveInstance().getRootUrl();
        if (url != null) {
            return url;
        }
        return Secret.fromString("key").toString();
    }

    public void set(Authentication a) throws IOException, InterruptedException {
        Jenkins h = Jenkins.getActiveInstance();
        UserDetails u = h.getSecurityRealm().loadUserByUsername(a.getName());
        this.props.setProperty(this.getPropertyKey(), Secret.fromString(u.getUsername()).getEncryptedValue());
        this.save();
    }

    public void remove() throws IOException, InterruptedException {
        if (this.props.remove(this.getPropertyKey()) != null) {
            this.save();
        }
    }

    private void save() throws IOException, InterruptedException {
        try (OutputStream os = this.store.write();){
            this.props.store(os, "Credential store");
        }
        this.store.chmod(384);
    }
}

