/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.Util;
import hudson.cli.CliEntryPoint;
import hudson.cli.CliManagerImpl;
import hudson.cli.Connection;
import hudson.model.Computer;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import javax.inject.Inject;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.slaves.NioChannelSelector;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.nio.NioChannelHub;

@Extension
@Symbol(value={"cli"})
public class CliProtocol
extends AgentProtocol {
    @Inject
    NioChannelSelector nio;
    private static final boolean OPT_IN;

    @Override
    public boolean isOptIn() {
        return OPT_IN;
    }

    @Override
    public String getName() {
        return "CLI-connect";
    }

    @Override
    public String getDisplayName() {
        return "Jenkins CLI Protocol/1";
    }

    @Override
    public void handle(Socket socket) throws IOException, InterruptedException {
        new Handler(this.nio.getHub(), socket).run();
    }

    static {
        byte hash = Util.fromHexString(Jenkins.getInstance().getLegacyInstanceId())[0];
        OPT_IN = hash % 10 == 0;
    }

    protected static class Handler {
        protected final NioChannelHub hub;
        protected final Socket socket;

        @Deprecated
        public Handler(Socket socket) {
            this(null, socket);
        }

        public Handler(NioChannelHub hub, Socket socket) {
            this.hub = hub;
            this.socket = socket;
        }

        public void run() throws IOException, InterruptedException {
            PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8")), true);
            out.println("Welcome");
            this.runCli(new Connection(this.socket));
        }

        protected void runCli(Connection c) throws IOException, InterruptedException {
            String name = "CLI channel from " + this.socket.getInetAddress();
            ChannelBuilder cb = new ChannelBuilder(name, Computer.threadPoolForRemoting);
            Channel channel = cb.withMode(Channel.Mode.BINARY).withRestricted(true).withBaseLoader(Jenkins.getActiveInstance().pluginManager.uberClassLoader).build(new BufferedInputStream(c.in), new BufferedOutputStream(c.out));
            channel.setProperty(CliEntryPoint.class.getName(), new CliManagerImpl(channel));
            channel.join();
        }
    }
}

