/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CLICommand;
import hudson.cli.CliEntryPoint;
import hudson.cli.CliTransportAuthenticator;
import hudson.cli.Connection;
import hudson.cli.HelpCommand;
import hudson.remoting.CallableFilter;
import hudson.remoting.Channel;
import hudson.remoting.Pipe;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public class CliManagerImpl
implements CliEntryPoint,
Serializable {
    private final transient Channel channel;
    private Authentication transportAuth;
    private final transient CallableFilter authenticationFilter = new CallableFilter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <V> V call(Callable<V> callable) throws Exception {
            SecurityContext context = SecurityContextHolder.getContext();
            Authentication old = context.getAuthentication();
            if (CliManagerImpl.this.transportAuth != null) {
                context.setAuthentication(CliManagerImpl.this.transportAuth);
            }
            try {
                V v = callable.call();
                return v;
            }
            finally {
                context.setAuthentication(old);
            }
        }
    };
    private static final Logger LOGGER = Logger.getLogger(CliManagerImpl.class.getName());

    public CliManagerImpl(Channel channel) {
        this.channel = channel;
        channel.addLocalExecutionInterceptor(this.authenticationFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(List<String> args, Locale locale, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        PrintStream out = new PrintStream(stdout);
        PrintStream err = new PrintStream(stderr);
        String subCmd = args.get(0);
        CLICommand cmd = CLICommand.clone(subCmd);
        if (cmd != null) {
            cmd.channel = Channel.current();
            CLICommand old = CLICommand.setCurrent(cmd);
            try {
                this.transportAuth = Channel.current().getProperty(CLICommand.TRANSPORT_AUTHENTICATION);
                cmd.setTransportAuth(this.transportAuth);
                int n = cmd.main(args.subList(1, args.size()), locale, stdin, out, err);
                return n;
            }
            finally {
                CLICommand.setCurrent(old);
            }
        }
        err.println("No such command: " + subCmd);
        new HelpCommand().main(Collections.emptyList(), locale, stdin, out, err);
        return -1;
    }

    public void authenticate(final String protocol, final Pipe c2s, final Pipe s2c) {
        for (final CliTransportAuthenticator cta : CliTransportAuthenticator.all()) {
            if (!cta.supportsProtocol(protocol)) continue;
            new Thread(){

                @Override
                public void run() {
                    cta.authenticate(protocol, CliManagerImpl.this.channel, new Connection(c2s.getIn(), s2c.getOut()));
                }
            }.start();
            return;
        }
        throw new UnsupportedOperationException("Unsupported authentication protocol: " + protocol);
    }

    public boolean hasCommand(String name) {
        return CLICommand.clone(name) != null;
    }

    public int protocolVersion() {
        return 1;
    }

    private Object writeReplace() {
        return Channel.current().export(CliEntryPoint.class, this);
    }
}

