/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.cli.ClientAuthenticationCache;
import hudson.cli.HelpCommand;
import hudson.cli.LoginCommand;
import hudson.cli.declarative.OptionHandlerExtension;
import hudson.remoting.Channel;
import hudson.remoting.ChannelProperty;
import hudson.security.CliAuthenticator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.SystemProperties;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.ClassParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.spi.OptionHandler;

@ExtensionPoint.LegacyInstancesAreScopedToHudson
public abstract class CLICommand
implements ExtensionPoint,
Cloneable {
    public transient PrintStream stdout;
    public transient PrintStream stderr;
    static final String CLI_LISTPARAM_SUMMARY_ERROR_TEXT = "Error occurred while performing this command, see previous stderr output.";
    public transient InputStream stdin;
    public transient Channel channel;
    public transient Locale locale;
    private transient Authentication transportAuth;
    private static final Logger LOGGER = Logger.getLogger(CLICommand.class.getName());
    public static final ChannelProperty<Authentication> TRANSPORT_AUTHENTICATION = new ChannelProperty<Authentication>(Authentication.class, "transportAuthentication");
    private static final ThreadLocal<CLICommand> CURRENT_COMMAND = new ThreadLocal();

    public String getName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        if ((name = name.substring(name.lastIndexOf(36) + 1)).endsWith("Command")) {
            name = name.substring(0, name.length() - 7);
        }
        return name.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ENGLISH);
    }

    public abstract String getShortDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = new BufferedInputStream(stdin);
        this.stdout = stdout;
        this.stderr = stderr;
        this.locale = locale;
        this.registerOptionHandlers();
        CmdLineParser p = this.getCmdLineParser();
        SecurityContext sc = null;
        Authentication old = null;
        try {
            sc = SecurityContextHolder.getContext();
            old = sc.getAuthentication();
            CliAuthenticator authenticator = Jenkins.getActiveInstance().getSecurityRealm().createCliAuthenticator(this);
            sc.setAuthentication(this.getTransportAuthentication());
            new ClassParser().parse(authenticator, p);
            p.parseArgument(args.toArray(new String[args.size()]));
            Authentication auth = authenticator.authenticate();
            if (auth == Jenkins.ANONYMOUS) {
                auth = this.loadStoredAuthentication();
            }
            sc.setAuthentication(auth);
            if (!(this instanceof LoginCommand) && !(this instanceof HelpCommand)) {
                Jenkins.getActiveInstance().checkPermission(Jenkins.READ);
            }
            int n = this.run();
            return n;
        }
        catch (CmdLineException e) {
            stderr.println("");
            stderr.println("ERROR: " + e.getMessage());
            this.printUsage(stderr, p);
            int auth = 2;
            return auth;
        }
        catch (IllegalStateException e) {
            stderr.println("");
            stderr.println("ERROR: " + e.getMessage());
            int auth = 4;
            return auth;
        }
        catch (IllegalArgumentException e) {
            stderr.println("");
            stderr.println("ERROR: " + e.getMessage());
            int auth = 3;
            return auth;
        }
        catch (AbortException e) {
            stderr.println("");
            stderr.println("ERROR: " + e.getMessage());
            int auth = 5;
            return auth;
        }
        catch (AccessDeniedException e) {
            stderr.println("");
            stderr.println("ERROR: " + e.getMessage());
            int auth = 6;
            return auth;
        }
        catch (BadCredentialsException e) {
            String id = UUID.randomUUID().toString();
            LOGGER.log(Level.INFO, "CLI login attempt failed: " + id, e);
            stderr.println("");
            stderr.println("ERROR: Bad Credentials. Search the server log for " + id + " for more details.");
            int n = 7;
            return n;
        }
        catch (Throwable e) {
            String errorMsg = String.format("Unexpected exception occurred while performing %s command.", this.getName());
            stderr.println("");
            stderr.println("ERROR: " + errorMsg);
            LOGGER.log(Level.WARNING, errorMsg, e);
            e.printStackTrace(stderr);
            int n = 1;
            return n;
        }
        finally {
            if (sc != null) {
                sc.setAuthentication(old);
            }
        }
    }

    protected CmdLineParser getCmdLineParser() {
        return new CmdLineParser(this);
    }

    public Channel checkChannel() throws AbortException {
        if (this.channel == null) {
            throw new AbortException("This command can only run with Jenkins CLI. See https://wiki.jenkins-ci.org/display/JENKINS/Jenkins+CLI");
        }
        return this.channel;
    }

    protected Authentication loadStoredAuthentication() throws InterruptedException {
        try {
            if (this.channel != null) {
                return new ClientAuthenticationCache(this.channel).get();
            }
        }
        catch (IOException e) {
            this.stderr.println("Failed to access the stored credential");
            e.printStackTrace(this.stderr);
        }
        return Jenkins.ANONYMOUS;
    }

    protected boolean shouldPerformAuthentication(Authentication auth) {
        return auth == Jenkins.ANONYMOUS;
    }

    public Authentication getTransportAuthentication() {
        Authentication a = this.transportAuth;
        if (a == null) {
            a = Jenkins.ANONYMOUS;
        }
        return a;
    }

    public void setTransportAuth(Authentication transportAuth) {
        this.transportAuth = transportAuth;
    }

    protected abstract int run() throws Exception;

    protected void printUsage(PrintStream stderr, CmdLineParser p) {
        stderr.print("java -jar jenkins-cli.jar " + this.getName());
        p.printSingleLineUsage(stderr);
        stderr.println();
        this.printUsageSummary(stderr);
        p.printUsage(stderr);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getSingleLineSummary() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getCmdLineParser().printSingleLineUsage(out);
        return out.toString();
    }

    @Restricted(value={NoExternalUse.class})
    public final String getUsage() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getCmdLineParser().printUsage(out);
        return out.toString();
    }

    @Restricted(value={NoExternalUse.class})
    public final String getLongDescription() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        this.printUsageSummary(ps);
        ps.close();
        return out.toString();
    }

    protected void printUsageSummary(PrintStream stderr) {
        stderr.println(this.getShortDescription());
    }

    protected String getClientSystemProperty(String name) throws IOException, InterruptedException {
        return this.checkChannel().call(new GetSystemProperty(name));
    }

    protected Charset getClientCharset() throws IOException, InterruptedException {
        if (this.channel == null) {
            return Charset.defaultCharset();
        }
        String charsetName = this.checkChannel().call(new GetCharset());
        try {
            return Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            LOGGER.log(Level.FINE, "Server doesn't have charset " + charsetName);
            return Charset.defaultCharset();
        }
    }

    protected String getClientEnvironmentVariable(String name) throws IOException, InterruptedException {
        return this.checkChannel().call(new GetEnvironmentVariable(name));
    }

    protected CLICommand createClone() {
        try {
            return (CLICommand)this.getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void registerOptionHandlers() {
        try {
            for (Class c : Index.list(OptionHandlerExtension.class, (ClassLoader)Jenkins.getActiveInstance().pluginManager.uberClassLoader, Class.class)) {
                Type t = Types.getBaseClass((Type)c, OptionHandler.class);
                CmdLineParser.registerHandler(Types.erasure((Type)Types.getTypeArgument((Type)t, (int)0)), c);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static ExtensionList<CLICommand> all() {
        return ExtensionList.lookup(CLICommand.class);
    }

    public static CLICommand clone(String name) {
        for (CLICommand cmd : CLICommand.all()) {
            if (!name.equals(cmd.getName())) continue;
            return cmd.createClone();
        }
        return null;
    }

    static CLICommand setCurrent(CLICommand cmd) {
        CLICommand old = CLICommand.getCurrent();
        CURRENT_COMMAND.set(cmd);
        return old;
    }

    public static CLICommand getCurrent() {
        return CURRENT_COMMAND.get();
    }

    static {
        ClassLoaders cls = new ClassLoaders();
        Jenkins j = Jenkins.getActiveInstance();
        if (j != null) {
            cls.put(j.getPluginManager().uberClassLoader);
            ResourceNameIterator servicesIter = new DiscoverServiceNames(cls).findResourceNames(OptionHandler.class.getName());
            ResourceClassIterator itr = new DiscoverClasses(cls).findResourceClasses(servicesIter);
            while (itr.hasNext()) {
                Class h = itr.nextResourceClass().loadClass();
                Class c = Types.erasure((Type)Types.getTypeArgument((Type)Types.getBaseClass((Type)h, OptionHandler.class), (int)0));
                CmdLineParser.registerHandler(c, h);
            }
        }
    }

    private static final class GetEnvironmentVariable
    extends MasterToSlaveCallable<String, IOException> {
        private final String name;
        private static final long serialVersionUID = 1L;

        private GetEnvironmentVariable(String name) {
            this.name = name;
        }

        @Override
        public String call() throws IOException {
            return System.getenv(this.name);
        }
    }

    private static final class GetCharset
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private GetCharset() {
        }

        @Override
        public String call() throws IOException {
            return Charset.defaultCharset().name();
        }
    }

    private static final class GetSystemProperty
    extends MasterToSlaveCallable<String, IOException> {
        private final String name;
        private static final long serialVersionUID = 1L;

        private GetSystemProperty(String name) {
            this.name = name;
        }

        @Override
        public String call() throws IOException {
            return SystemProperties.getString(this.name);
        }
    }
}

