/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import hudson.Util;
import hudson.util.AtomicFileWriter;
import hudson.util.XStream2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlFile {
    private final XStream xs;
    private final File file;
    private static final XStream DEFAULT_XSTREAM = new XStream2();
    private static final Logger LOGGER = Logger.getLogger(XmlFile.class.getName());
    private static final SAXParserFactory JAXP = SAXParserFactory.newInstance();
    private static final Xpp3Driver DEFAULT_DRIVER = new Xpp3Driver();

    public XmlFile(File file) {
        this(DEFAULT_XSTREAM, file);
    }

    public XmlFile(XStream xs, File file) {
        this.xs = xs;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public XStream getXStream() {
        return this.xs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object read() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading " + this.file);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            Object object = this.xs.fromXML((InputStream)in);
            return object;
        }
        catch (XStreamException | Error e) {
            throw new IOException("Unable to read " + this.file, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(Object o) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            Object object = this.xs.unmarshal(DEFAULT_DRIVER.createReader((InputStream)in), o);
            return object;
        }
        catch (XStreamException | Error e) {
            throw new IOException("Unable to read " + this.file, e);
        }
    }

    public void write(Object o) throws IOException {
        this.mkdirs();
        AtomicFileWriter w = new AtomicFileWriter(this.file);
        try {
            w.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            this.xs.toXML(o, (Writer)w);
            w.commit();
        }
        catch (StreamException e) {
            throw new IOException(e);
        }
        finally {
            w.abort();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    public void mkdirs() {
        this.file.getParentFile().mkdirs();
    }

    public String toString() {
        return this.file.toString();
    }

    public Reader readRaw() throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.sniffEncoding());
    }

    public String asString() throws IOException {
        StringWriter w = new StringWriter();
        this.writeRawTo(w);
        return w.toString();
    }

    public void writeRawTo(Writer w) throws IOException {
        try (Reader r = this.readRaw();){
            Util.copyStream(r, w);
        }
    }

    public String sniffEncoding() throws IOException {
        class Eureka
        extends SAXException {
            final String encoding;

            public Eureka(String encoding) {
                this.encoding = encoding;
            }
        }
        try {
            FileInputStream in = new FileInputStream(this.file);
            Throwable throwable = null;
            try {
                try {
                    InputSource input = new InputSource(this.file.toURI().toASCIIString());
                    input.setByteStream(in);
                    JAXP.newSAXParser().parse(input, new DefaultHandler(){
                        private Locator loc;

                        @Override
                        public void setDocumentLocator(Locator locator) {
                            this.loc = locator;
                        }

                        @Override
                        public void startDocument() throws SAXException {
                            this.attempt();
                        }

                        @Override
                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                            this.attempt();
                            throw new Eureka(null);
                        }

                        private void attempt() throws Eureka {
                            Locator2 loc2;
                            String e;
                            if (this.loc == null) {
                                return;
                            }
                            if (this.loc instanceof Locator2 && (e = (loc2 = (Locator2)this.loc).getEncoding()) != null) {
                                throw new Eureka(e);
                            }
                        }
                    });
                    throw new AssertionError();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Eureka e) {
            if (e.encoding != null) {
                return e.encoding;
            }
            return "UTF-8";
        }
        catch (SAXException e) {
            throw new IOException("Failed to detect encoding of " + this.file, e);
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        JAXP.setNamespaceAware(true);
    }
}

