/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.Extension;
import hudson.Messages;
import hudson.slaves.OfflineCause;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.Charset;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.AgentProtocol;
import jenkins.model.Jenkins;
import jenkins.model.identity.InstanceIdentityProvider;
import jenkins.util.SystemProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;

public final class TcpSlaveAgentListener
extends Thread {
    private final ServerSocketChannel serverSocket;
    private volatile boolean shuttingDown;
    public final int configuredPort;
    private static int iotaGen = 1;
    private static final Logger LOGGER = Logger.getLogger(TcpSlaveAgentListener.class.getName());
    public static String CLI_HOST_NAME = SystemProperties.getString(TcpSlaveAgentListener.class.getName() + ".hostName");
    public static Integer CLI_PORT = SystemProperties.getInteger(TcpSlaveAgentListener.class.getName() + ".port");

    public TcpSlaveAgentListener(int port) throws IOException {
        super("TCP agent listener port=" + port);
        try {
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.socket().bind(new InetSocketAddress(port));
        }
        catch (BindException e) {
            throw (BindException)new BindException("Failed to listen on port " + port + " because it's already in use.").initCause(e);
        }
        this.configuredPort = port;
        LOGGER.log(Level.FINE, "JNLP agent listener started on TCP port {0}", this.getPort());
        this.start();
    }

    public int getPort() {
        return this.serverSocket.socket().getLocalPort();
    }

    public int getAdvertisedPort() {
        return CLI_PORT != null ? CLI_PORT.intValue() : this.getPort();
    }

    @Nullable
    public String getIdentityPublicKey() {
        RSAPublicKey key = InstanceIdentityProvider.RSA.getPublicKey();
        return key == null ? null : new String(Base64.encodeBase64((byte[])key.getEncoded()), Charset.forName("UTF-8"));
    }

    public String getAgentProtocolNames() {
        return StringUtils.join(Jenkins.getInstance().getAgentProtocols(), (String)", ");
    }

    @Override
    public void run() {
        block3: {
            try {
                while (!this.shuttingDown) {
                    Socket s = this.serverSocket.accept().socket();
                    s.setKeepAlive(true);
                    s.setTcpNoDelay(true);
                    new ConnectionHandler(s).start();
                }
            }
            catch (IOException e) {
                if (this.shuttingDown) break block3;
                LOGGER.log(Level.SEVERE, "Failed to accept JNLP agent connections", e);
            }
        }
    }

    public void shutdown() {
        this.shuttingDown = true;
        try {
            SocketAddress localAddress = this.serverSocket.getLocalAddress();
            if (localAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)localAddress;
                Socket client = new Socket(address.getHostName(), address.getPort());
                client.setSoTimeout(1000);
                new PingAgentProtocol().connect(client);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Failed to send Ping to wake acceptor loop", e);
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to close down TCP port", e);
        }
    }

    public static class ConnectionFromCurrentPeer
    extends OfflineCause {
        public String toString() {
            return "The current peer is reconnecting";
        }
    }

    @Extension
    public static class PingAgentProtocol
    extends AgentProtocol {
        private final byte[] ping;

        public PingAgentProtocol() {
            try {
                this.ping = "Ping\n".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("JLS mandates support for UTF-8 charset", e);
            }
        }

        @Override
        public boolean isRequired() {
            return true;
        }

        @Override
        public String getName() {
            return "Ping";
        }

        @Override
        public String getDisplayName() {
            return Messages.TcpSlaveAgentListener_PingAgentProtocol_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Socket socket) throws IOException, InterruptedException {
            try (OutputStream stream = socket.getOutputStream();){
                LOGGER.log(Level.FINE, "Received ping request from {0}", socket.getRemoteSocketAddress());
                stream.write(this.ping);
                stream.flush();
                LOGGER.log(Level.FINE, "Sent ping response to {0}", socket.getRemoteSocketAddress());
            }
            finally {
                socket.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean connect(Socket socket) throws IOException {
            try {
                int responseLength;
                byte[] response;
                InputStream in;
                DataOutputStream out;
                block8: {
                    boolean bl;
                    out = null;
                    in = null;
                    try {
                        LOGGER.log(Level.FINE, "Requesting ping from {0}", socket.getRemoteSocketAddress());
                        out = new DataOutputStream(socket.getOutputStream());
                        out.writeUTF("Protocol:Ping");
                        in = socket.getInputStream();
                        response = new byte[this.ping.length];
                        responseLength = in.read(response);
                        if (responseLength != this.ping.length || !Arrays.equals(response, this.ping)) break block8;
                        LOGGER.log(Level.FINE, "Received ping response from {0}", socket.getRemoteSocketAddress());
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((InputStream)in);
                    return bl;
                }
                LOGGER.log(Level.FINE, "Expected ping response from {0} of {1} got {2}", new Object[]{socket.getRemoteSocketAddress(), new String(this.ping, "UTF-8"), new String(response, 0, responseLength, "UTF-8")});
                boolean bl = false;
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                return bl;
            }
            finally {
                socket.close();
            }
        }
    }

    private final class ConnectionHandler
    extends Thread {
        private final Socket s;
        private final int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionHandler(Socket s) {
            this.s = s;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.id = iotaGen++;
            }
            this.setName("TCP agent connection handler #" + this.id + " with " + s.getRemoteSocketAddress());
        }

        @Override
        public void run() {
            try {
                LOGGER.log(Level.INFO, "Accepted connection #{0} from {1}", new Object[]{this.id, this.s.getRemoteSocketAddress()});
                DataInputStream in = new DataInputStream(this.s.getInputStream());
                PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.s.getOutputStream(), "UTF-8")), true);
                byte[] head = new byte[10];
                in.readFully(head);
                String header = new String(head, Charsets.US_ASCII);
                if (header.startsWith("GET ")) {
                    this.respondHello(header, this.s);
                    return;
                }
                String s = new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(head), in)).readUTF();
                if (s.startsWith("Protocol:")) {
                    String protocol = s.substring(9);
                    AgentProtocol p = AgentProtocol.of(protocol);
                    if (p != null) {
                        if (Jenkins.getInstance().getAgentProtocols().contains(protocol)) {
                            p.handle(this.s);
                        } else {
                            this.error(out, "Disabled protocol:" + s);
                        }
                    } else {
                        this.error(out, "Unknown protocol:" + s);
                    }
                } else {
                    this.error(out, "Unrecognized protocol: " + s);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Connection #" + this.id + " aborted", e);
                try {
                    this.s.close();
                }
                catch (IOException _) {}
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Connection #" + this.id + " failed", e);
                try {
                    this.s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void respondHello(String header, Socket s) throws IOException {
            try {
                OutputStreamWriter o = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
                if (header.startsWith("GET / ")) {
                    o.write("HTTP/1.0 200 OK\r\n");
                    o.write("Content-Type: text/plain;charset=UTF-8\r\n");
                    o.write("\r\n");
                    o.write("Jenkins-Agent-Protocols: " + TcpSlaveAgentListener.this.getAgentProtocolNames() + "\r\n");
                    o.write("Jenkins-Version: " + Jenkins.VERSION + "\r\n");
                    o.write("Jenkins-Session: " + Jenkins.SESSION_HASH + "\r\n");
                    o.write("Client: " + s.getInetAddress().getHostAddress() + "\r\n");
                    o.write("Server: " + s.getLocalAddress().getHostAddress() + "\r\n");
                    ((Writer)o).flush();
                    s.shutdownOutput();
                } else {
                    o.write("HTTP/1.0 404 Not Found\r\n");
                    o.write("Content-Type: text/plain;charset=UTF-8\r\n");
                    o.write("\r\n");
                    o.write("Not Found\r\n");
                    ((Writer)o).flush();
                    s.shutdownOutput();
                }
                InputStream i = s.getInputStream();
                IOUtils.copy((InputStream)i, (OutputStream)new NullOutputStream());
                s.shutdownInput();
            }
            finally {
                s.close();
            }
        }

        private void error(PrintWriter out, String msg) throws IOException {
            out.println(msg);
            LOGGER.log(Level.WARNING, "Connection #" + this.id + " is aborted: " + msg);
            this.s.close();
        }
    }
}

