/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.BulkChange;
import hudson.PluginWrapper;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class Plugin
implements Saveable {
    transient PluginWrapper wrapper;

    @Deprecated
    protected Plugin() {
    }

    public void setServletContext(ServletContext context) {
    }

    public PluginWrapper getWrapper() {
        return this.wrapper;
    }

    public void start() throws Exception {
    }

    public void postInitialize() throws Exception {
    }

    public void stop() throws Exception {
    }

    @Deprecated
    public void configure(JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.configure(formData);
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String requestPath;
        boolean staticLink;
        String path = req.getRestOfPath();
        if (path.startsWith("/META-INF/") || path.startsWith("/WEB-INF/")) {
            throw HttpResponses.notFound();
        }
        if (path.length() == 0) {
            path = "/";
        }
        long expires = (staticLink = (requestPath = req.getRequestURI().substring(req.getContextPath().length())).startsWith("/static/")) ? TimeUnit2.DAYS.toMillis(365L) : -1L;
        try {
            rsp.serveLocalizedFile(req, this.wrapper.baseResourceURL.toURI().resolve(new URI(null, '.' + path, null)).toURL(), expires);
        }
        catch (URISyntaxException x) {
            throw new IOException(x);
        }
    }

    protected void load() throws IOException {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            xml.unmarshal(this);
        }
    }

    @Override
    public void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile config = this.getConfigXml();
        config.write(this);
        SaveableListener.fireOnChange(this, config);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getInstance().getRootDir(), this.wrapper.getShortName() + ".xml"));
    }

    public static final class DummyImpl
    extends Plugin {
    }
}

