/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectException;

public class PropertiesLoader
implements Serializable {
    @Nonnull
    public Map<String, String> getVarsFromPropertiesFile(@Nonnull File propertiesFile, @Nonnull Map<String, String> currentEnvVars) throws EnvInjectException {
        if (propertiesFile == null) {
            throw new NullPointerException("The properties file object must be set.");
        }
        if (!propertiesFile.exists()) {
            throw new IllegalArgumentException("The properties file object must be exist.");
        }
        try {
            String fileContent = Util.loadFile((File)propertiesFile);
            return this.getVars(fileContent, currentEnvVars);
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Problem occurs on loading content", (Throwable)ioe);
        }
    }

    @Nonnull
    public Map<String, String> getVarsFromPropertiesContent(@Nonnull String content, @Nonnull Map<String, String> currentEnvVars) throws EnvInjectException {
        if (content == null) {
            throw new NullPointerException("A properties content must be set.");
        }
        if (content.trim().length() == 0) {
            throw new IllegalArgumentException("A properties content must be not empty.");
        }
        return this.getVars(content, currentEnvVars);
    }

    @Nonnull
    private Map<String, String> getVars(@Nonnull String content, @Nonnull Map<String, String> currentEnvVars) throws EnvInjectException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringReader stringReader = new StringReader(content);
        Properties properties = new Properties();
        try {
            properties.load(stringReader);
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Problem occurs on loading content", (Throwable)ioe);
        }
        finally {
            stringReader.close();
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(this.processElement(entry.getKey(), currentEnvVars), this.processElement(entry.getValue(), currentEnvVars));
        }
        return result;
    }

    @CheckForNull
    private String processElement(@CheckForNull Object prop, @Nonnull Map<String, String> currentEnvVars) {
        String macroProcessedElement = Util.replaceMacro((String)String.valueOf(prop), currentEnvVars);
        if (macroProcessedElement == null) {
            return null;
        }
        return macroProcessedElement.trim();
    }
}

