/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.EnvVars;
import hudson.Util;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.EnvironmentContributor;
import hudson.model.EnvironmentList;
import hudson.model.Executor;
import hudson.model.Hudson;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPluginAction;
import org.jenkinsci.plugins.envinject.service.BuildCauseRetriever;

public class EnvInjectVariableGetter {
    private static Logger LOG = Logger.getLogger(EnvInjectVariableGetter.class.getName());

    @Nonnull
    public Map<String, String> getJenkinsSystemVariables(boolean forceOnMaster) throws IOException, InterruptedException {
        String rootUrl;
        EnvVars result = new TreeMap();
        Jenkins jenkins = Jenkins.getActiveInstance();
        Computer computer = forceOnMaster ? jenkins.toComputer() : Computer.currentComputer();
        if (computer != null) {
            result = computer.getEnvironment().overrideAll(result);
            if (computer instanceof Hudson.MasterComputer) {
                result.put("NODE_NAME", "master");
            } else {
                result.put("NODE_NAME", computer.getName());
            }
            Node n = computer.getNode();
            if (n != null) {
                result.put("NODE_LABELS", Util.join((Collection)n.getAssignedLabels(), (String)" "));
            }
        }
        if ((rootUrl = jenkins.getRootUrl()) != null) {
            result.put("JENKINS_URL", rootUrl);
            result.put("HUDSON_URL", rootUrl);
        }
        result.put("JENKINS_HOME", jenkins.getRootDir().getPath());
        result.put("HUDSON_HOME", jenkins.getRootDir().getPath());
        return result;
    }

    public Map<String, String> getBuildVariables(@Nonnull AbstractBuild build, @Nonnull EnvInjectLogger logger) throws EnvInjectException {
        String rootUrl;
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll((Map<String, String>)build.getCharacteristicEnvVars());
        try {
            EnvVars envVars = new EnvVars();
            for (EnvironmentContributor ec : EnvironmentContributor.all()) {
                ec.buildEnvironmentFor((Run)build, envVars, (TaskListener)new LogTaskListener(LOG, Level.ALL));
                result.putAll((Map<String, String>)envVars);
            }
            JDK jdk = build.getProject().getJDK();
            if (jdk != null) {
                Node node = build.getBuiltOn();
                if (node != null) {
                    jdk = jdk.forNode(node, logger.getListener());
                }
                jdk.buildEnvVars(result);
            }
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException((Throwable)ie);
        }
        Executor e = build.getExecutor();
        if (e != null) {
            result.put("EXECUTOR_NUMBER", String.valueOf(e.getNumber()));
        }
        if ((rootUrl = Jenkins.getActiveInstance().getRootUrl()) != null) {
            result.put("BUILD_URL", rootUrl + build.getUrl());
            result.put("JOB_URL", rootUrl + build.getParent().getUrl());
        }
        result.putAll(build.getBuildVariables());
        Map<String, String> triggerVariable = new BuildCauseRetriever().getTriggeredCause(build);
        result.putAll(triggerVariable);
        return result;
    }

    @CheckForNull
    public EnvInjectJobProperty getEnvInjectJobProperty(@Nonnull AbstractBuild build) {
        EnvInjectJobPropertyInfo info;
        if (build == null) {
            throw new IllegalArgumentException("A build object must be set.");
        }
        Job job = build instanceof MatrixRun ? ((MatrixRun)build).getParentBuild().getParent() : build.getParent();
        EnvInjectJobProperty envInjectJobProperty = (EnvInjectJobProperty)job.getProperty(EnvInjectJobProperty.class);
        if (envInjectJobProperty != null && (info = envInjectJobProperty.getInfo()) != null && envInjectJobProperty.isOn()) {
            return envInjectJobProperty;
        }
        return null;
    }

    @Nonnull
    public Map<String, String> getEnvVarsPreviousSteps(@Nonnull AbstractBuild build, @Nonnull EnvInjectLogger logger) throws IOException, InterruptedException, EnvInjectException {
        EnvInjectPluginAction envInjectAction;
        HashMap<String, String> result = new HashMap<String, String>();
        EnvironmentList environmentList = build.getEnvironments();
        if (environmentList != null) {
            for (Environment e : environmentList) {
                if (e == null) continue;
                e.buildEnvVars(result);
            }
        }
        if ((envInjectAction = (EnvInjectPluginAction)build.getAction(EnvInjectPluginAction.class)) != null) {
            result.putAll(this.getCurrentInjectedEnvVars(envInjectAction));
            if (build instanceof MatrixRun) {
                result.putAll(build.getBuildVariables());
            }
        } else {
            result.putAll(this.getJenkinsSystemVariables(false));
            result.putAll(this.getBuildVariables(build, logger));
        }
        return result;
    }

    @Nonnull
    private Map<String, String> getCurrentInjectedEnvVars(@Nonnull EnvInjectPluginAction envInjectPluginAction) {
        Map envVars = envInjectPluginAction.getEnvMap();
        return envVars == null ? new HashMap() : envVars;
    }
}

