/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import java.io.File;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.envinject.EnvInjectPlugin;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class EnvInjectPluginConfiguration
extends GlobalConfiguration {
    private static final EnvInjectPluginConfiguration DEFAULT = new EnvInjectPluginConfiguration(false, false);
    private boolean hideInjectedVars;
    private boolean enablePermissions;

    public EnvInjectPluginConfiguration() {
        this.load();
    }

    public EnvInjectPluginConfiguration(boolean hideInjectedVars, boolean enablePermissions) {
        this.hideInjectedVars = hideInjectedVars;
        this.enablePermissions = enablePermissions;
    }

    public boolean isHideInjectedVars() {
        return this.hideInjectedVars;
    }

    public boolean isEnablePermissions() {
        return this.enablePermissions;
    }

    @Nonnull
    public static final EnvInjectPluginConfiguration getDefault() {
        return DEFAULT;
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getActiveInstance().getRootDir(), "envinject-plugin-configuration.xml"));
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        boolean newEnablePermissions = json.getBoolean("enablePermissions");
        boolean newHideInjectedVars = json.getBoolean("hideInjectedVars");
        return EnvInjectPluginConfiguration.configure(newHideInjectedVars, newEnablePermissions);
    }

    @VisibleForTesting
    static boolean configure(boolean hideInjectedVars, boolean enablePermissions) {
        EnvInjectPluginConfiguration instance = EnvInjectPluginConfiguration.getInstance();
        if (instance == null) {
            throw new IllegalStateException("Cannot retrieve the plugin config instance");
        }
        instance.hideInjectedVars = hideInjectedVars;
        instance.enablePermissions = enablePermissions;
        EnvInjectPlugin.getInstance().onConfigChange(instance);
        instance.save();
        return true;
    }

    @CheckForNull
    public static EnvInjectPluginConfiguration getInstance() {
        return (EnvInjectPluginConfiguration)((Object)EnvInjectPluginConfiguration.all().get(EnvInjectPluginConfiguration.class));
    }
}

