/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.EnvironmentContributingAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectAction;
import org.jenkinsci.plugins.envinject.EnvInjectPlugin;
import org.jenkinsci.plugins.envinject.EnvInjectVarList;

public class EnvInjectPluginAction
extends EnvInjectAction
implements EnvironmentContributingAction {
    public EnvInjectPluginAction(@Nonnull AbstractBuild build, @CheckForNull Map<String, String> envMap) {
        super(build, envMap);
    }

    public String getIconFileName() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.getOwner())) {
            return null;
        }
        return super.getIconFileName();
    }

    public String getUrlName() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.getOwner())) {
            return null;
        }
        return super.getUrlName();
    }

    public Object getTarget() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.getOwner())) {
            return EnvInjectVarList.HIDDEN;
        }
        return this.getEnvInjectVarList();
    }

    @Nonnull
    private EnvInjectVarList getEnvInjectVarList() {
        if (this.envMap == null) {
            return new EnvInjectVarList(Collections.<String, String>emptyMap());
        }
        return new EnvInjectVarList(Maps.transformEntries((Map)this.envMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                Set sensibleVars = EnvInjectPluginAction.this.getSensibleVariables();
                return sensibleVars != null && sensibleVars.contains(key) ? "[*******]" : value;
            }
        }));
    }

    public void buildEnvVars(@Nonnull AbstractBuild<?, ?> build, @Nonnull EnvVars env) {
        if (this.envMap != null) {
            env.putAll(this.envMap);
        }
    }
}

