/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.Launcher;
import hudson.console.LineTransformationOutputStream;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectGlobalPasswordEntry;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.service.EnvInjectGlobalPasswordRetriever;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class EnvInjectPasswordWrapper
extends BuildWrapper {
    private static final Function<EnvInjectPasswordEntry, String> PASSWORD_ENTRY_TO_NAME = new Function<EnvInjectPasswordEntry, String>(){

        public String apply(EnvInjectPasswordEntry envInjectPasswordEntry) {
            if (envInjectPasswordEntry == null) {
                throw new NullPointerException("Received null EnvInject password entry");
            }
            return envInjectPasswordEntry.getName();
        }
    };
    private static final Function<EnvInjectPasswordEntry, String> PASSWORD_ENTRY_TO_VALUE = new Function<EnvInjectPasswordEntry, String>(){

        public String apply(EnvInjectPasswordEntry envInjectPasswordEntry) {
            if (envInjectPasswordEntry == null) {
                throw new NullPointerException("Received null EnvInject password entry");
            }
            return envInjectPasswordEntry.getValue().getPlainText();
        }
    };
    private boolean injectGlobalPasswords;
    private boolean maskPasswordParameters;
    @CheckForNull
    private EnvInjectPasswordEntry[] passwordEntries;

    @DataBoundConstructor
    public EnvInjectPasswordWrapper() {
    }

    public boolean isInjectGlobalPasswords() {
        return this.injectGlobalPasswords;
    }

    public boolean isMaskPasswordParameters() {
        return this.maskPasswordParameters;
    }

    public void setInjectGlobalPasswords(boolean injectGlobalPasswords) {
        this.injectGlobalPasswords = injectGlobalPasswords;
    }

    public void setMaskPasswordParameters(boolean maskPasswordParameters) {
        this.maskPasswordParameters = maskPasswordParameters;
    }

    @CheckForNull
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public EnvInjectPasswordEntry[] getPasswordEntries() {
        return this.passwordEntries == null ? null : Arrays.copyOf(this.passwordEntries, this.passwordEntries.length);
    }

    @Nonnull
    public List<EnvInjectPasswordEntry> getPasswordEntryList() {
        if (this.passwordEntries == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.passwordEntries));
    }

    public void setPasswordEntries(@CheckForNull EnvInjectPasswordEntry[] passwordEntries) {
        this.passwordEntries = passwordEntries;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        if (this.isInjectGlobalPasswords()) {
            logger.info("Inject global passwords.");
        }
        if (this.isMaskPasswordParameters()) {
            logger.info("Mask passwords that will be passed as build parameters.");
        }
        return new BuildWrapper.Environment(){};
    }

    @Nonnull
    private List<EnvInjectPasswordEntry> getEnvInjectPasswordEntries() throws EnvInjectException {
        EnvInjectGlobalPasswordRetriever globalPasswordRetriever;
        EnvInjectGlobalPasswordEntry[] passwordEntries;
        ArrayList<EnvInjectPasswordEntry> passwordList = new ArrayList<EnvInjectPasswordEntry>();
        if (this.isInjectGlobalPasswords() && (passwordEntries = (globalPasswordRetriever = new EnvInjectGlobalPasswordRetriever()).getGlobalPasswords()) != null) {
            passwordList.addAll(Arrays.asList(passwordEntries));
        }
        passwordList.addAll(this.getPasswordEntryList());
        return passwordList;
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream outputStream) throws IOException, InterruptedException, Run.RunnerAbortedException {
        try {
            List parameters;
            ParametersAction parametersAction;
            ArrayList passwords2decorate = Lists.newArrayList((Iterable)Lists.transform(this.getEnvInjectPasswordEntries(), PASSWORD_ENTRY_TO_VALUE));
            if (this.isMaskPasswordParameters() && (parametersAction = (ParametersAction)build.getAction(ParametersAction.class)) != null && (parameters = parametersAction.getParameters()) != null) {
                for (ParameterValue parameter : parameters) {
                    if (!(parameter instanceof PasswordParameterValue)) continue;
                    PasswordParameterValue passwordParameterValue = (PasswordParameterValue)parameter;
                    passwords2decorate.add(passwordParameterValue.getValue().getPlainText());
                }
            }
            return new EnvInjectPasswordsOutputStream(outputStream, passwords2decorate);
        }
        catch (EnvInjectException ee) {
            throw new Run.RunnerAbortedException();
        }
    }

    public void makeSensitiveBuildVariables(AbstractBuild build, Set<String> sensitiveVariables) {
        try {
            sensitiveVariables.addAll(Lists.transform(this.getEnvInjectPasswordEntries(), PASSWORD_ENTRY_TO_NAME));
        }
        catch (EnvInjectException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        try {
            EnvInjectGlobalPasswordRetriever globalPasswordRetriever;
            EnvInjectGlobalPasswordEntry[] passwordEntries;
            ArrayList<EnvInjectPasswordEntry> passwordList = new ArrayList<EnvInjectPasswordEntry>();
            if (this.isInjectGlobalPasswords() && (passwordEntries = (globalPasswordRetriever = new EnvInjectGlobalPasswordRetriever()).getGlobalPasswords()) != null) {
                passwordList.addAll(Arrays.asList(passwordEntries));
            }
            passwordList.addAll(this.getPasswordEntryList());
            for (EnvInjectPasswordEntry passwordEntry : passwordList) {
                variables.put(passwordEntry.getName(), passwordEntry.getValue().getPlainText());
            }
        }
        catch (EnvInjectException ee) {
            throw new Run.RunnerAbortedException();
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.EnvInjectPasswordWrapper_DisplayName();
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            EnvInjectPasswordWrapper passwordWrapper = new EnvInjectPasswordWrapper();
            passwordWrapper.setInjectGlobalPasswords(formData.getBoolean("injectGlobalPasswords"));
            passwordWrapper.setMaskPasswordParameters(formData.getBoolean("maskPasswordParameters"));
            List passwordEntries = req.bindJSONToList(EnvInjectPasswordEntry.class, formData.get("passwordEntry"));
            passwordWrapper.setPasswordEntries(passwordEntries.toArray(new EnvInjectPasswordEntry[passwordEntries.size()]));
            return passwordWrapper;
        }
    }

    class EnvInjectPasswordsOutputStream
    extends LineTransformationOutputStream {
        @Nonnull
        private final OutputStream logger;
        @CheckForNull
        private final Pattern passwordsAsPattern;

        EnvInjectPasswordsOutputStream(@CheckForNull OutputStream logger, Collection<String> passwords) {
            this.logger = logger;
            if (passwords != null && passwords.size() > 0) {
                StringBuilder regex = new StringBuilder().append('(');
                int nbMaskedPasswords = 0;
                for (String password : passwords) {
                    if (!StringUtils.isNotEmpty((String)password)) continue;
                    regex.append(Pattern.quote(password));
                    regex.append('|');
                    ++nbMaskedPasswords;
                }
                if (nbMaskedPasswords >= 1) {
                    regex.deleteCharAt(regex.length() - 1);
                    regex.append(')');
                    this.passwordsAsPattern = Pattern.compile(regex.toString());
                } else {
                    this.passwordsAsPattern = null;
                }
            } else {
                this.passwordsAsPattern = null;
            }
        }

        protected void eol(byte[] bytes, int len) throws IOException {
            String line = new String(bytes, 0, len);
            if (this.passwordsAsPattern != null) {
                line = this.passwordsAsPattern.matcher(line).replaceAll("[*******]");
            }
            this.logger.write(line.getBytes());
        }

        public void close() throws IOException {
            super.close();
            this.logger.close();
        }
    }
}

