/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPasswordEntry;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributor;
import org.jenkinsci.plugins.envinject.model.EnvInjectJobPropertyContributorDescriptor;
import org.jenkinsci.plugins.envinject.service.EnvInjectContributorManagement;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class EnvInjectJobProperty<T extends Job<?, ?>>
extends JobProperty<T> {
    @CheckForNull
    private EnvInjectJobPropertyInfo info = new EnvInjectJobPropertyInfo();
    private boolean on;
    private boolean keepJenkinsSystemVariables;
    private boolean keepBuildVariables;
    private boolean overrideBuildParameters;
    @CheckForNull
    @GuardedBy(value="this")
    private EnvInjectJobPropertyContributor[] contributors;
    @CheckForNull
    @GuardedBy(value="this")
    private transient EnvInjectJobPropertyContributor[] contributorsComputed;
    @Deprecated
    private transient boolean injectGlobalPasswords;
    @Deprecated
    private transient EnvInjectPasswordEntry[] passwordEntries;
    @Deprecated
    private transient boolean keepSystemVariables;

    @DataBoundConstructor
    public EnvInjectJobProperty(EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public EnvInjectJobProperty() {
    }

    @CheckForNull
    public EnvInjectJobPropertyInfo getInfo() {
        return this.info;
    }

    public boolean isOn() {
        return this.on;
    }

    public boolean isKeepJenkinsSystemVariables() {
        return this.keepJenkinsSystemVariables;
    }

    public boolean isKeepBuildVariables() {
        return this.keepBuildVariables;
    }

    public boolean isOverrideBuildParameters() {
        return this.overrideBuildParameters;
    }

    @Nonnull
    public synchronized EnvInjectJobPropertyContributor[] getContributors() {
        if (this.contributorsComputed == null) {
            try {
                this.contributorsComputed = this.computeEnvInjectContributors();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
            }
            this.contributors = this.contributorsComputed;
        }
        return this.contributors != null ? Arrays.copyOf(this.contributors, this.contributors.length) : new EnvInjectJobPropertyContributor[]{};
    }

    @Nonnull
    private synchronized EnvInjectJobPropertyContributor[] computeEnvInjectContributors() throws EnvInjectException {
        DescriptorExtensionList<EnvInjectJobPropertyContributor, EnvInjectJobPropertyContributorDescriptor> descriptors = EnvInjectJobPropertyContributor.all();
        if (this.contributors != null && this.contributors.length == descriptors.size()) {
            return this.contributors;
        }
        EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
        EnvInjectJobPropertyContributor[] contributorsInstance = envInjectContributorManagement.getNewContributorsInstance();
        if (this.contributors == null || this.contributors.length == 0) {
            return contributorsInstance;
        }
        ArrayList<EnvInjectJobPropertyContributor> result = new ArrayList<EnvInjectJobPropertyContributor>();
        for (EnvInjectJobPropertyContributor contributor1 : contributorsInstance) {
            for (EnvInjectJobPropertyContributor contributor2 : this.contributors) {
                if (contributor1.getDescriptor().getClass() == contributor2.getDescriptor().getClass()) {
                    result.add(contributor2);
                    continue;
                }
                result.add(contributor1);
            }
        }
        return result.toArray(new EnvInjectJobPropertyContributor[result.size()]);
    }

    @Deprecated
    public void setInfo(@CheckForNull EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    @DataBoundSetter
    public void setOn(boolean on) {
        this.on = on;
    }

    @DataBoundSetter
    public void setKeepJenkinsSystemVariables(boolean keepJenkinsSystemVariables) {
        this.keepJenkinsSystemVariables = keepJenkinsSystemVariables;
    }

    @DataBoundSetter
    public void setKeepBuildVariables(boolean keepBuildVariables) {
        this.keepBuildVariables = keepBuildVariables;
    }

    @DataBoundSetter
    public void setOverrideBuildParameters(boolean overrideBuildParameters) {
        this.overrideBuildParameters = overrideBuildParameters;
    }

    @DataBoundSetter
    public synchronized void setContributors(EnvInjectJobPropertyContributor[] jobPropertyContributors) {
        this.contributors = jobPropertyContributors;
    }

    public JobProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        EnvInjectJobProperty property = (EnvInjectJobProperty)super.reconfigure(req, form);
        if (property != null && property.info != null && !Jenkins.getActiveInstance().hasPermission(Jenkins.RUN_SCRIPTS)) {
            property.info = new EnvInjectJobPropertyInfo(property.info.propertiesFilePath, property.info.propertiesContent, property.info.getScriptFilePath(), property.info.getScriptContent(), this.info != null ? this.info.getGroovyScriptContent() : "", property.info.isLoadFilesFromMaster());
        }
        return property;
    }

    @Deprecated
    public boolean isInjectGlobalPasswords() {
        return this.injectGlobalPasswords;
    }

    @Deprecated
    @CheckForNull
    public EnvInjectPasswordEntry[] getPasswordEntries() {
        return this.passwordEntries;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return "[Environment Inject] -" + Messages.envinject_set_displayName();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/envinject/help.html";
        }

        public EnvInjectJobProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.optBoolean("on")) {
                return (EnvInjectJobProperty)super.newInstance(req, formData);
            }
            return null;
        }

        @Nonnull
        public DescriptorExtensionList<EnvInjectJobPropertyContributor, EnvInjectJobPropertyContributorDescriptor> getEnvInjectContributors() {
            return EnvInjectJobPropertyContributor.all();
        }

        @CheckForNull
        public EnvInjectJobPropertyContributor[] getContributorsInstance() {
            EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
            try {
                return envInjectContributorManagement.getNewContributorsInstance();
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
                return null;
            }
        }

        public boolean isEnvInjectContributionActivated() {
            EnvInjectContributorManagement envInjectContributorManagement = new EnvInjectContributorManagement();
            return envInjectContributorManagement.isEnvInjectContributionActivated();
        }
    }
}

