/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectBuilderContributionAction;
import org.jenkinsci.plugins.envinject.EnvInjectInfo;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.kohsuke.stapler.DataBoundConstructor;

public class EnvInjectBuilder
extends Builder
implements Serializable {
    @Nonnull
    private EnvInjectInfo info;

    @DataBoundConstructor
    public EnvInjectBuilder(String propertiesFilePath, String propertiesContent) {
        this.info = new EnvInjectInfo(propertiesFilePath, propertiesContent);
    }

    @Nonnull
    public EnvInjectInfo getInfo() {
        return this.info;
    }

    public boolean perform(@Nonnull AbstractBuild<?, ?> build, @Nonnull Launcher launcher, @Nonnull BuildListener listener) throws InterruptedException, IOException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        logger.info("Injecting environment variables from a build step.");
        FilePath ws = build.getWorkspace();
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
        EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
        try {
            SCM scm;
            EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
            Map<String, String> previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
            HashMap<String, String> variables = new HashMap<String, String>(previousEnvVars);
            if (ws != null && variables.get("WORKSPACE") == null) {
                variables.put("WORKSPACE", ws.getRemote());
            }
            if ((scm = build.getProject().getScm()) != null) {
                scm.buildEnvVars(build, variables);
            }
            variables.putAll(this.getAndAddBuildVariables(build));
            Map<String, String> resultVariables = variables;
            if (ws != null) {
                Map<String, String> propertiesEnvVars = envInjectEnvVarsService.getEnvVarsFileProperty(ws, logger, this.info.getPropertiesFilePath(), this.info.getPropertiesContentMap(previousEnvVars), variables);
                resultVariables = envInjectEnvVarsService.getMergedVariables(variables, propertiesEnvVars);
            }
            build.addAction((Action)new EnvInjectBuilderContributionAction(resultVariables));
            envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
        }
        catch (Throwable throwable) {
            logger.error("Problems occurs on injecting env vars as a build step: " + throwable.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    private Map<String, String> getAndAddBuildVariables(@Nonnull AbstractBuild build) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(build.getBuildVariables());
        FilePath ws = build.getWorkspace();
        if (ws != null && result.get("WORKSPACE") == null) {
            result.put("WORKSPACE", ws.getRemote());
        }
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return Messages.envinject_addVars_displayName();
        }

        public String getHelpFile() {
            return "/plugin/envinject/help-buildStep.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

