/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.Messages;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.kohsuke.stapler.DataBoundConstructor;

public class EnvInjectBuildWrapper
extends BuildWrapper
implements Serializable {
    @Nonnull
    private EnvInjectJobPropertyInfo info;
    private static final Logger LOGGER = Logger.getLogger(EnvInjectBuildWrapper.class.getName());

    @DataBoundConstructor
    public EnvInjectBuildWrapper(@Nonnull EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    @Deprecated
    public EnvInjectBuildWrapper() {
        this.info = new EnvInjectJobPropertyInfo();
    }

    @Deprecated
    public void setInfo(@Nonnull EnvInjectJobPropertyInfo info) {
        this.info = info;
    }

    @Nonnull
    public EnvInjectJobPropertyInfo getInfo() {
        return this.info;
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        return super.decorateLogger(build, logger);
    }

    public BuildWrapper.Environment setUp(@Nonnull AbstractBuild build, @Nonnull Launcher launcher, @Nonnull BuildListener listener) throws IOException, InterruptedException {
        EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
        logger.info("Executing scripts and injecting environment variables after the SCM step.");
        EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
        FilePath ws = build.getWorkspace();
        EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
        EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
        try {
            SCM scm;
            Map<String, String> previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
            HashMap<String, String> injectedEnvVars = new HashMap<String, String>(previousEnvVars);
            if (ws != null && injectedEnvVars.get("WORKSPACE") == null) {
                injectedEnvVars.put("WORKSPACE", ws.getRemote());
            }
            if ((scm = build.getProject().getScm()) != null) {
                scm.buildEnvVars(build, injectedEnvVars);
            }
            Map<String, String> groovyMapEnvVars = envInjectEnvVarsService.executeAndGetMapGroovyScript(logger, this.info.getGroovyScriptContent(), injectedEnvVars);
            Map<String, String> emptyVars = Collections.emptyMap();
            Map<String, String> propertiesEnvVars = ws != null ? envInjectEnvVarsService.getEnvVarsFileProperty(ws, logger, this.info.getPropertiesFilePath(), this.info.getPropertiesContentMap(previousEnvVars), injectedEnvVars) : emptyVars;
            final Map<String, String> resultVariables = envInjectEnvVarsService.getMergedVariables(injectedEnvVars, propertiesEnvVars, groovyMapEnvVars, emptyVars);
            int resultCode = envInjectEnvVarsService.executeScript(this.info.getScriptContent(), ws, this.info.getScriptFilePath(), resultVariables, launcher, listener);
            if (resultCode != 0) {
                logger.info("Fail the build.");
                build.setResult(Result.FAILURE);
                return null;
            }
            envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
            return new BuildWrapper.Environment(){

                public void buildEnvVars(Map<String, String> env) {
                    env.putAll(resultVariables);
                }
            };
        }
        catch (Throwable throwable) {
            logger.error("Problems occurs on injecting env vars defined in the build wrapper: " + throwable + ". See system log for more info");
            LOGGER.log(Level.WARNING, String.format("Problems occurs on injecting env vars defined in the build wrapper for build {0}", build), throwable);
            build.setResult(Result.FAILURE);
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return Messages.envinject_wrapper_displayName();
        }

        public String getHelpFile() {
            return "/plugin/envinject/help-buildWrapper.html";
        }
    }
}

