/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildVariableContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectPluginAction;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.jenkinsci.plugins.envinject.service.EnvironmentVariablesNodeLoader;

@Extension
public class EnvInjectBuildVariableContributor
extends BuildVariableContributor {
    public void buildVariablesFor(@Nonnull AbstractBuild build, @Nonnull Map<String, String> variablesOut) {
        ParametersAction parameters = (ParametersAction)build.getAction(ParametersAction.class);
        if (parameters != null) {
            EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
            EnvInjectJobProperty envInjectJobProperty = variableGetter.getEnvInjectJobProperty(build);
            if (envInjectJobProperty == null) {
                return;
            }
            if (!envInjectJobProperty.isOverrideBuildParameters()) {
                return;
            }
            EnvironmentVariablesNodeLoader environmentVariablesNodeLoader = new EnvironmentVariablesNodeLoader();
            Map<Object, Object> nodeEnvVars = new HashMap();
            try {
                nodeEnvVars = environmentVariablesNodeLoader.gatherEnvironmentVariablesNode(build, build.getBuiltOn(), new EnvInjectLogger(TaskListener.NULL));
            }
            catch (EnvInjectException e) {
                e.printStackTrace();
            }
            EnvInjectPluginAction envInjectAction = (EnvInjectPluginAction)build.getAction(EnvInjectPluginAction.class);
            if (envInjectAction != null) {
                for (ParameterValue p : parameters) {
                    String key = p.getName();
                    Map injectedEnvVars = envInjectAction.getEnvMap();
                    if (injectedEnvVars == null) {
                        return;
                    }
                    if (!injectedEnvVars.containsKey(key) || nodeEnvVars.containsKey(key)) continue;
                    variablesOut.put(key, (String)injectedEnvVars.get(key));
                }
            }
        }
    }
}

