/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.ChannelBuilder;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.nio.NioChannelHub;

public class JnlpServerHandshake {
    protected final NioChannelHub hub;
    protected final Socket socket;
    protected final DataInputStream in;
    protected final PrintWriter out;
    protected final Properties request = new Properties();
    private final ExecutorService threadPool;
    static final Logger LOGGER = Logger.getLogger(JnlpServerHandshake.class.getName());

    protected JnlpServerHandshake(NioChannelHub hub, ExecutorService threadPool, Socket socket) throws IOException {
        this.hub = hub;
        this.threadPool = threadPool;
        this.socket = socket;
        this.in = new DataInputStream(socket.getInputStream());
        this.out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8")), true);
    }

    protected JnlpServerHandshake(JnlpServerHandshake rhs) {
        this.hub = rhs.hub;
        this.threadPool = rhs.threadPool;
        this.socket = rhs.socket;
        this.in = rhs.in;
        this.out = rhs.out;
    }

    public NioChannelHub getHub() {
        return this.hub;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public DataInputStream getIn() {
        return this.in;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public Properties getRequestProperties() {
        return this.request;
    }

    public String getRequestProperty(String name) {
        return this.request.getProperty(name);
    }

    public void error(String msg) throws IOException {
        this.out.println(msg);
        LOGGER.log(Level.WARNING, Thread.currentThread().getName() + " is aborted: " + msg);
        this.socket.close();
    }

    public void success(Properties response) {
        this.out.println("Welcome");
        for (Map.Entry<Object, Object> e : response.entrySet()) {
            this.out.println(e.getKey() + ": " + e.getValue());
        }
        this.out.println();
    }

    public ChannelBuilder createChannelBuilder(String nodeName) {
        if (this.hub == null) {
            return new ChannelBuilder(nodeName, this.threadPool);
        }
        return this.hub.newChannelBuilder(nodeName, this.threadPool);
    }
}

