/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.console.LineTransformationOutputStream;
import hudson.plugins.gradle.GradleOutcomeNote;
import hudson.plugins.gradle.GradleTaskNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class GradleConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private boolean nextLineIsBuildScan;
    private String scanUrl;

    public GradleConsoleAnnotator(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        if ((line = this.trimEOL(line)).startsWith(":")) {
            new GradleTaskNote().encodeTo(this.out);
        }
        if (line.equals("BUILD SUCCESSFUL") || line.equals("BUILD FAILED")) {
            new GradleOutcomeNote().encodeTo(this.out);
        }
        if (this.nextLineIsBuildScan) {
            this.scanUrl = line;
            this.nextLineIsBuildScan = false;
        }
        if (line.equals("Publishing build information...")) {
            this.nextLineIsBuildScan = true;
        }
        this.out.write(b, 0, len);
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }

    public String getScanUrl() {
        return this.scanUrl;
    }
}

