/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.gradle;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.gradle.BuildScanAction;
import hudson.plugins.gradle.GradleConsoleAnnotator;
import hudson.plugins.gradle.GradleInstallation;
import hudson.plugins.gradle.GradleLogger;
import hudson.plugins.gradle.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.dryrun.DryRun;
import org.kohsuke.stapler.DataBoundConstructor;

public class Gradle
extends Builder
implements DryRun {
    private final String description;
    private final String switches;
    private final String tasks;
    private final String rootBuildScriptDir;
    private final String buildFile;
    private final String gradleName;
    private final boolean useWrapper;
    private final boolean makeExecutable;
    private final boolean fromRootBuildScriptDir;
    private final boolean useWorkspaceAsHome;
    private final boolean passAsProperties;

    @DataBoundConstructor
    public Gradle(String description, String switches, String tasks, String rootBuildScriptDir, String buildFile, String gradleName, boolean useWrapper, boolean makeExecutable, boolean fromRootBuildScriptDir, boolean useWorkspaceAsHome, boolean passAsProperties) {
        this.description = description;
        this.switches = switches;
        this.tasks = tasks;
        this.gradleName = gradleName;
        this.rootBuildScriptDir = rootBuildScriptDir;
        this.buildFile = buildFile;
        this.useWrapper = useWrapper;
        this.makeExecutable = makeExecutable;
        this.fromRootBuildScriptDir = fromRootBuildScriptDir;
        this.useWorkspaceAsHome = useWorkspaceAsHome;
        this.passAsProperties = passAsProperties;
    }

    public String getSwitches() {
        return this.switches;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getGradleName() {
        return this.gradleName;
    }

    public String getTasks() {
        return this.tasks;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isUseWrapper() {
        return this.useWrapper;
    }

    public String getRootBuildScriptDir() {
        return this.rootBuildScriptDir;
    }

    public boolean isMakeExecutable() {
        return this.makeExecutable;
    }

    public boolean isFromRootBuildScriptDir() {
        return this.fromRootBuildScriptDir;
    }

    public boolean isUseWorkspaceAsHome() {
        return this.useWorkspaceAsHome;
    }

    public boolean isPassAsProperties() {
        return this.passAsProperties;
    }

    public GradleInstallation getGradle() {
        for (GradleInstallation i : this.getDescriptor().getInstallations()) {
            if (this.gradleName == null || !i.getName().equals(this.gradleName)) continue;
            return i;
        }
        return null;
    }

    private static String null2Blank(String input) {
        return input != null ? input : "";
    }

    private static String append(String input, String textToAppend) {
        if (StringUtils.isBlank((String)input)) {
            return Gradle.null2Blank(textToAppend);
        }
        if (StringUtils.isBlank((String)textToAppend)) {
            return Gradle.null2Blank(input);
        }
        return input + " " + textToAppend;
    }

    public boolean performDryRun(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.performTask(true, build, launcher, listener);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.performTask(false, build, launcher, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performTask(boolean dryRun, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath rootLauncher;
        GradleLogger gradleLogger = new GradleLogger((TaskListener)listener);
        gradleLogger.info("Launching build.");
        EnvVars env = build.getEnvironment((TaskListener)listener);
        String extraSwitches = (String)env.get((Object)"GRADLE_EXT_SWITCHES");
        String normalizedSwitches = Gradle.append(this.switches, extraSwitches);
        normalizedSwitches = normalizedSwitches.replaceAll("[\t\r\n]+", " ");
        normalizedSwitches = Util.replaceMacro((String)normalizedSwitches, (Map)env);
        normalizedSwitches = Util.replaceMacro((String)normalizedSwitches, (Map)build.getBuildVariables());
        if (dryRun) {
            normalizedSwitches = normalizedSwitches + " --dry-run";
        }
        String extraTasks = (String)env.get((Object)"GRADLE_EXT_TASKS");
        String normalizedTasks = Gradle.append(this.tasks, extraTasks);
        normalizedTasks = normalizedTasks.replaceAll("[\t\r\n]+", " ");
        normalizedTasks = Util.replaceMacro((String)normalizedTasks, (Map)env);
        normalizedTasks = Util.replaceMacro((String)normalizedTasks, (Map)build.getBuildVariables());
        FilePath normalizedRootBuildScriptDir = null;
        if (this.rootBuildScriptDir != null && this.rootBuildScriptDir.trim().length() != 0) {
            String rootBuildScriptNormalized = this.rootBuildScriptDir.trim().replaceAll("[\t\r\n]+", " ");
            rootBuildScriptNormalized = Util.replaceMacro((String)rootBuildScriptNormalized.trim(), (Map)env);
            rootBuildScriptNormalized = Util.replaceMacro((String)rootBuildScriptNormalized, (VariableResolver)build.getBuildVariableResolver());
            normalizedRootBuildScriptDir = new FilePath(build.getModuleRoot(), rootBuildScriptNormalized);
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        if (this.useWrapper) {
            FilePath gradleWrapperFile;
            String execName;
            String string = execName = launcher.isUnix() ? "gradlew" : "gradlew.bat";
            if (this.fromRootBuildScriptDir && normalizedRootBuildScriptDir != null) {
                gradleWrapperFile = new FilePath(normalizedRootBuildScriptDir, execName);
            } else {
                FilePath baseDir;
                FilePath candidate;
                int fileSeparator;
                int i;
                gradleWrapperFile = new FilePath(build.getModuleRoot(), execName);
                if (this.buildFile != null && !this.buildFile.isEmpty() && (i = this.buildFile.lastIndexOf(fileSeparator = launcher.isUnix() ? 47 : 92)) > 0 && (candidate = new FilePath(baseDir = build.getModuleRoot(), this.buildFile.substring(0, i))).isDirectory() && new FilePath(candidate, execName).exists()) {
                    gradleWrapperFile = new FilePath(candidate, execName);
                }
            }
            if (this.makeExecutable) {
                gradleWrapperFile.chmod(484);
            }
            args.add(gradleWrapperFile.getRemote());
        } else {
            GradleInstallation ai = this.getGradle();
            if (ai != null) {
                Node node;
                Computer computer = Computer.currentComputer();
                Node node2 = node = computer != null ? computer.getNode() : null;
                if (node == null) {
                    gradleLogger.error("Not in a build node.");
                    return false;
                }
                ai = ai.forNode(node, (TaskListener)listener);
                String exe = (ai = ai.forEnvironment(env)).getExecutable(launcher);
                if (exe == null) {
                    gradleLogger.error("Can't retrieve the Gradle executable.");
                    return false;
                }
                env.put("GRADLE_HOME", ai.getHome());
                args.add(exe);
            } else {
                args.add(launcher.isUnix() ? "gradle" : "gradle.bat");
            }
        }
        Set sensitiveVars = build.getSensitiveBuildVariables();
        args.addKeyValuePairs(this.passPropertyOption(), this.fixParameters(build.getBuildVariables()), sensitiveVars);
        args.addTokenized(normalizedSwitches);
        args.addTokenized(normalizedTasks);
        if (this.buildFile != null && this.buildFile.trim().length() != 0) {
            String buildFileNormalized = Util.replaceMacro((String)this.buildFile.trim(), (Map)env);
            args.add("-b");
            args.add(buildFileNormalized);
        }
        FilePath workspace = build.getWorkspace();
        if (this.useWorkspaceAsHome && workspace != null) {
            env.put("GRADLE_USER_HOME", workspace.getRemote());
        }
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
        }
        if ((rootLauncher = normalizedRootBuildScriptDir != null ? normalizedRootBuildScriptDir : build.getWorkspace()) == null) {
            rootLauncher = build.getProject().getSomeWorkspace();
        }
        try {
            String scanUrl;
            int r;
            GradleConsoleAnnotator gca = new GradleConsoleAnnotator(listener.getLogger(), build.getCharset());
            try {
                r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)((Object)gca)).pwd(rootLauncher).join();
            }
            finally {
                gca.forceEol();
            }
            boolean success = r == 0;
            build.setResult(Result.SUCCESS);
            if (!success) {
                build.setResult(Result.FAILURE);
            }
            if (StringUtils.isNotEmpty((String)(scanUrl = gca.getScanUrl()))) {
                build.addAction((Action)new BuildScanAction(scanUrl));
            }
            return success;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("command execution failed"));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private String passPropertyOption() {
        return this.passAsProperties ? "-P" : "-D";
    }

    private Map<String, String> fixParameters(Map<String, String> parmas) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : parmas.entrySet()) {
            String value = entry.getValue();
            if (this.isValue2Escape(value)) {
                result.put(entry.getKey(), "\"" + value + "\"");
                continue;
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private boolean isValue2Escape(String value) {
        if (value == null) {
            return false;
        }
        if (value.trim().length() == 0) {
            return false;
        }
        return value.contains("<") || value.contains(">");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile GradleInstallation[] installations = new GradleInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends Gradle> clazz) {
            super(clazz);
        }

        public GradleInstallation.DescriptorImpl getToolDescriptor() {
            return (GradleInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(GradleInstallation.DescriptorImpl.class));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        protected void convert(Map<String, Object> oldPropertyBag) {
            if (oldPropertyBag.containsKey("installations")) {
                this.installations = (GradleInstallation[])oldPropertyBag.get("installations");
            }
        }

        public String getHelpFile() {
            return "/plugin/gradle/help.html";
        }

        public String getDisplayName() {
            return Messages.step_displayName();
        }

        public GradleInstallation[] getInstallations() {
            return Arrays.copyOf(this.installations, this.installations.length);
        }

        public void setInstallations(GradleInstallation ... installations) {
            this.installations = installations;
            this.save();
        }
    }
}

