/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.util;

import java.io.IOException;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class ModelUtil {
    private ModelUtil() {
    }

    public static String getFullItemUrl(FlowNode item) {
        try {
            return ModelUtil.getFullItemUrl(item.getUrl());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error getting URL for a Stage FlowNode.", e);
        }
    }

    public static String getFullItemUrl(String itemUrl) {
        String rootUrl = ModelUtil.getRootUrl();
        if (!itemUrl.endsWith("/")) {
            itemUrl = itemUrl + "/";
        }
        return rootUrl + "/" + itemUrl;
    }

    public static String getRootUrl() {
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        return currentRequest != null ? currentRequest.getContextPath() : "/";
    }
}

