/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;

public enum StatusExt {
    NOT_EXECUTED,
    ABORTED,
    SUCCESS,
    IN_PROGRESS,
    PAUSED_PENDING_INPUT,
    FAILED,
    UNSTABLE;


    public static StatusExt valueOf(ErrorAction errorAction) {
        if (errorAction == null) {
            return SUCCESS;
        }
        return StatusExt.valueOf(errorAction.getError());
    }

    public static StatusExt valueOf(Throwable t) {
        if (t instanceof FlowInterruptedException) {
            return ABORTED;
        }
        return FAILED;
    }

    public static StatusExt fromGenericStatus(@CheckForNull GenericStatus st) {
        if (st == null) {
            return NOT_EXECUTED;
        }
        switch (st) {
            case PAUSED_PENDING_INPUT: {
                return PAUSED_PENDING_INPUT;
            }
            case ABORTED: {
                return ABORTED;
            }
            case FAILURE: {
                return FAILED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case UNSTABLE: {
                return UNSTABLE;
            }
            case SUCCESS: {
                return SUCCESS;
            }
            case NOT_EXECUTED: {
                return NOT_EXECUTED;
            }
        }
        throw new IllegalStateException("Forbidden GenericStatus: " + st);
    }
}

