/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.flownode.FlowNodeUtil;
import com.cloudbees.workflow.rest.external.AtomFlowNodeExt;
import com.cloudbees.workflow.rest.external.ErrorExt;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class StageNodeExt
extends FlowNodeExt {
    private List<AtomFlowNodeExt> stageFlowNodes;
    transient List<String> allChildNodeIds = new ArrayList<String>();
    static final int MAX_CHILD_NODES = Integer.getInteger(StageNodeExt.class.getName() + ".maxChildNodes", 100);

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<AtomFlowNodeExt> getStageFlowNodes() {
        return this.stageFlowNodes;
    }

    public void setStageFlowNodes(List<AtomFlowNodeExt> stageFlowNodes) {
        this.stageFlowNodes = stageFlowNodes;
    }

    public static boolean isStageNode(FlowNode node) {
        return node.getAction(LabelAction.class) != null && node.getAction(ThreadNameAction.class) == null;
    }

    @JsonIgnore
    public List<String> getAllChildNodeIds() {
        return Collections.unmodifiableList(this.allChildNodeIds);
    }

    public StageNodeExt myWrapper() {
        return new ChildHidingWrapper(this);
    }

    @Override
    protected void calculateTimings(FlowNode node) {
    }

    private void addStageAtomNodeData(List<FlowNode> atomFlowNodes) {
        ArrayList<AtomFlowNodeExt> newNodes = new ArrayList<AtomFlowNodeExt>();
        for (FlowNode stageNode : atomFlowNodes) {
            if (!(stageNode instanceof AtomNode)) continue;
            if (newNodes.size() <= MAX_CHILD_NODES) {
                AtomFlowNodeExt atomFlowNodeExt = AtomFlowNodeExt.create(stageNode);
                if (atomFlowNodeExt.getStatus() == StatusExt.FAILED) {
                    this.setStatus(StatusExt.FAILED);
                }
                newNodes.add(atomFlowNodeExt);
            }
            if (FlowNodeUtil.getStatus(stageNode) != StatusExt.FAILED) continue;
            this.setStatus(StatusExt.FAILED);
        }
        this.setStageFlowNodes(newNodes);
    }

    protected static class ChildHidingWrapper
    extends StageNodeExt {
        protected StageNodeExt myNode;

        @Override
        public FlowNodeExt.FlowNodeLinks get_links() {
            return this.myNode.get_links();
        }

        @Override
        public String getId() {
            return this.myNode.getId();
        }

        @Override
        public String getName() {
            return this.myNode.getName();
        }

        @Override
        public String getExecNode() {
            return this.myNode.getExecNode();
        }

        @Override
        public StatusExt getStatus() {
            return this.myNode.getStatus();
        }

        @Override
        public ErrorExt getError() {
            return this.myNode.getError();
        }

        @Override
        public long getStartTimeMillis() {
            return this.myNode.getStartTimeMillis();
        }

        @Override
        public long getDurationMillis() {
            return this.myNode.getDurationMillis();
        }

        @Override
        public long getPauseDurationMillis() {
            return this.myNode.getPauseDurationMillis();
        }

        @Override
        public List<AtomFlowNodeExt> getStageFlowNodes() {
            return null;
        }

        protected ChildHidingWrapper(StageNodeExt stage) {
            this.myNode = stage;
        }
    }
}

