/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.flownode.FlowNodeUtil;
import com.cloudbees.workflow.rest.endpoints.RunAPI;
import com.cloudbees.workflow.rest.external.ChangeSetExt;
import com.cloudbees.workflow.rest.external.ChunkVisitor;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.cloudbees.workflow.rest.hal.Link;
import com.cloudbees.workflow.rest.hal.Links;
import com.fasterxml.jackson.annotation.JsonInclude;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageChunkFinder;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;

public class RunExt {
    private static int MAX_ARTIFACTS_COUNT = Integer.getInteger(RunExt.class.getName() + ".maxArtifactsCount", 100);
    private RunLinks _links;
    private String id;
    private String name;
    private StatusExt status;
    private long startTimeMillis;
    private long endTimeMillis;
    private long durationMillis;
    private long queueDurationMillis;
    private long pauseDurationMillis;
    private List<StageNodeExt> stages;

    public RunLinks get_links() {
        return this._links;
    }

    public void set_links(RunLinks _links) {
        this._links = _links;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public StatusExt getStatus() {
        return this.status;
    }

    public void setStatus(StatusExt status) {
        this.status = status;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public void setEndTimeMillis(long endTimeMillis) {
        this.endTimeMillis = endTimeMillis;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public long getQueueDurationMillis() {
        return this.queueDurationMillis;
    }

    public void setQueueDurationMillis(long queueDurationMillis) {
        this.queueDurationMillis = queueDurationMillis;
    }

    public long getPauseDurationMillis() {
        return this.pauseDurationMillis;
    }

    public void setPauseDurationMillis(long pauseDurationMillis) {
        this.pauseDurationMillis = pauseDurationMillis;
    }

    public List<StageNodeExt> getStages() {
        return this.stages;
    }

    public void setStages(List<StageNodeExt> stages) {
        this.stages = stages;
    }

    public static RunExt computeTimings(RunExt runExt) {
        for (StageNodeExt stage : runExt.getStages()) {
            runExt.setDurationMillis(runExt.getPauseDurationMillis() + stage.getPauseDurationMillis());
        }
        if (!runExt.getStages().isEmpty()) {
            FlowNodeExt lastStage = runExt.getLastStage();
            runExt.setEndTimeMillis(lastStage.getStartTimeMillis() + lastStage.getDurationMillis());
            lastStage.setStatus(runExt.getStatus());
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (runExt.getStatus() == StatusExt.IN_PROGRESS || runExt.getStatus() == StatusExt.PAUSED_PENDING_INPUT) {
            runExt.setEndTimeMillis(currentTimeMillis);
        }
        if (runExt.getStages().isEmpty()) {
            runExt.setQueueDurationMillis(currentTimeMillis - runExt.getStartTimeMillis());
        } else {
            StageNodeExt firstExecutedStage = runExt.getFirstExecutedStage();
            if (firstExecutedStage != null) {
                runExt.setQueueDurationMillis(firstExecutedStage.getStartTimeMillis() - runExt.getStartTimeMillis());
            }
        }
        runExt.setDurationMillis(Math.max(0L, runExt.getEndTimeMillis() - runExt.getStartTimeMillis() - runExt.getQueueDurationMillis()));
        return runExt;
    }

    public static RunExt createMinimal(WorkflowRun run) {
        FlowExecution execution = run.getExecution();
        RunExt runExt = new RunExt();
        runExt.set_links(new RunLinks());
        runExt.get_links().initSelf(RunAPI.getDescribeUrl(run));
        runExt.setId(run.getId());
        runExt.setName(run.getDisplayName());
        runExt.initStatus(run);
        runExt.setStartTimeMillis(run.getStartTimeInMillis());
        runExt.setStages(new ArrayList<StageNodeExt>());
        if (execution != null) {
            List artifacts;
            if (ChangeSetExt.hasChanges(run)) {
                runExt.get_links().setChangesets(Link.newLink(RunAPI.getChangeSetsUrl(run)));
            }
            if (RunExt.isPendingInput(run)) {
                runExt.get_links().setPendingInputActions(Link.newLink(RunAPI.getPendingInputActionsUrl(run)));
                runExt.get_links().setNextPendingInputAction(Link.newLink(RunAPI.getNextPendingInputActionUrl(run)));
            }
            if ((artifacts = run.getArtifactsUpTo(MAX_ARTIFACTS_COUNT)) != null && !artifacts.isEmpty()) {
                runExt.get_links().setArtifacts(Link.newLink(RunAPI.getArtifactsUrl(run)));
            }
        }
        return runExt;
    }

    public RunExt createWrapper() {
        return new ChildHidingWrapper(this);
    }

    public static RunExt create(WorkflowRun run) {
        RunExt myRun;
        FlowExecution execution = run.getExecution();
        boolean isNotRunning = FlowNodeUtil.isNotPartOfRunningBuild(execution);
        if (isNotRunning && (myRun = FlowNodeUtil.getCachedRun(run)) != null) {
            return myRun;
        }
        myRun = RunExt.createNew(run);
        if (isNotRunning) {
            FlowNodeUtil.cacheRun(run, myRun);
        }
        return myRun;
    }

    public static RunExt createNew(WorkflowRun run) {
        RunExt runExt = RunExt.createMinimal(run);
        FlowExecution execution = run.getExecution();
        if (execution != null) {
            ChunkVisitor visitor = new ChunkVisitor(run);
            ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
            runExt.setStages(new ArrayList<StageNodeExt>(visitor.stages));
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (runExt.getStatus() == StatusExt.IN_PROGRESS || runExt.getStatus() == StatusExt.PAUSED_PENDING_INPUT) {
            runExt.setEndTimeMillis(currentTimeMillis);
        }
        if (runExt.getStages().isEmpty()) {
            if (run.isBuilding()) {
                runExt.setQueueDurationMillis(currentTimeMillis - runExt.getStartTimeMillis());
            } else {
                runExt.setQueueDurationMillis(0L);
            }
        } else {
            StageNodeExt firstExecutedStage = runExt.getFirstExecutedStage();
            if (firstExecutedStage != null) {
                runExt.setQueueDurationMillis(firstExecutedStage.getStartTimeMillis() - runExt.getStartTimeMillis());
            }
        }
        runExt.setDurationMillis(Math.max(0L, runExt.getEndTimeMillis() - runExt.getStartTimeMillis() - runExt.getQueueDurationMillis()));
        return runExt;
    }

    public static boolean isPendingInput(WorkflowRun run) {
        List executions;
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        return inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty();
    }

    private void initStatus(WorkflowRun run) {
        FlowExecution execution = run.getExecution();
        if (execution == null) {
            this.setStatus(StatusExt.NOT_EXECUTED);
        } else if (execution.getCauseOfFailure() != null) {
            this.setStatus(StatusExt.valueOf(execution.getCauseOfFailure()));
        } else if (execution.isComplete()) {
            Result r = run.getResult();
            if (r == Result.NOT_BUILT) {
                this.setStatus(StatusExt.NOT_EXECUTED);
            } else if (r == Result.ABORTED) {
                this.setStatus(StatusExt.ABORTED);
            } else if (r == Result.FAILURE) {
                this.setStatus(StatusExt.FAILED);
            } else if (r == Result.UNSTABLE) {
                this.setStatus(StatusExt.UNSTABLE);
            } else if (r == Result.SUCCESS) {
                this.setStatus(StatusExt.SUCCESS);
            } else {
                this.setStatus(StatusExt.FAILED);
            }
        } else if (RunExt.isPendingInput(run)) {
            this.setStatus(StatusExt.PAUSED_PENDING_INPUT);
        } else {
            this.setStatus(StatusExt.IN_PROGRESS);
        }
    }

    private StageNodeExt getFirstExecutedStage() {
        for (int i = 0; i < this.getStages().size(); ++i) {
            StageNodeExt stage = this.getStages().get(i);
            if (stage.getStatus() == StatusExt.NOT_EXECUTED) continue;
            return stage;
        }
        return null;
    }

    private FlowNodeExt getLastStage() {
        if (this.getStages().isEmpty()) {
            return null;
        }
        return this.getStages().get(this.getStages().size() - 1);
    }

    protected static class ChildHidingWrapper
    extends RunExt {
        protected RunExt myRun;
        protected List<StageNodeExt> wrappedStages;

        @Override
        public RunLinks get_links() {
            return this.myRun.get_links();
        }

        @Override
        public String getId() {
            return this.myRun.getId();
        }

        @Override
        public String getName() {
            return this.myRun.getName();
        }

        @Override
        public StatusExt getStatus() {
            return this.myRun.getStatus();
        }

        @Override
        public long getStartTimeMillis() {
            return this.myRun.getStartTimeMillis();
        }

        @Override
        public long getEndTimeMillis() {
            return this.myRun.getEndTimeMillis();
        }

        @Override
        public long getDurationMillis() {
            return this.myRun.getDurationMillis();
        }

        @Override
        public long getQueueDurationMillis() {
            return this.myRun.getQueueDurationMillis();
        }

        @Override
        public long getPauseDurationMillis() {
            return this.myRun.getPauseDurationMillis();
        }

        @Override
        public List<StageNodeExt> getStages() {
            return Collections.unmodifiableList(this.wrappedStages);
        }

        protected ChildHidingWrapper(RunExt run) {
            this.myRun = run;
            ArrayList<StageNodeExt> myWrappedStages = new ArrayList<StageNodeExt>();
            if (this.wrappedStages == null) {
                for (StageNodeExt stage : run.getStages()) {
                    myWrappedStages.add(stage.myWrapper());
                }
                this.wrappedStages = myWrappedStages;
            } else {
                this.wrappedStages = null;
            }
        }
    }

    public static final class RunLinks
    extends Links {
        private Link changesets;
        private Link pendingInputActions;
        private Link nextPendingInputAction;
        private Link artifacts;

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Link getChangesets() {
            return this.changesets;
        }

        public void setChangesets(Link changesets) {
            this.changesets = changesets;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Link getPendingInputActions() {
            return this.pendingInputActions;
        }

        public void setPendingInputActions(Link pendingInputActions) {
            this.pendingInputActions = pendingInputActions;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Link getNextPendingInputAction() {
            return this.nextPendingInputAction;
        }

        public void setNextPendingInputAction(Link nextPendingInputAction) {
            this.nextPendingInputAction = nextPendingInputAction;
        }

        public Link getArtifacts() {
            return this.artifacts;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setArtifacts(Link artifacts) {
            this.artifacts = artifacts;
        }
    }
}

