/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.rest.endpoints.RunAPI;
import com.cloudbees.workflow.rest.external.InputParameterDefExt;
import com.cloudbees.workflow.util.ModelUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import hudson.model.ParameterDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;

public class PendingInputActionsExt {
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String proceedText;
    private String message;
    private List<InputParameterDefExt> inputs;
    private String proceedUrl;
    private String abortUrl;
    private String redirectApprovalUrl;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProceedText() {
        return this.proceedText;
    }

    public void setProceedText(String proceedText) {
        this.proceedText = proceedText;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<InputParameterDefExt> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<InputParameterDefExt> inputs) {
        this.inputs = inputs;
    }

    public String getProceedUrl() {
        return this.proceedUrl;
    }

    public void setProceedUrl(String proceedUrl) {
        this.proceedUrl = proceedUrl;
    }

    public String getAbortUrl() {
        return this.abortUrl;
    }

    public void setAbortUrl(String abortUrl) {
        this.abortUrl = abortUrl;
    }

    public String getRedirectApprovalUrl() {
        return this.redirectApprovalUrl;
    }

    public void setRedirectApprovalUrl(String redirectApprovalUrl) {
        this.redirectApprovalUrl = redirectApprovalUrl;
    }

    public static PendingInputActionsExt create(InputStepExecution inputStepExecution, WorkflowRun run) {
        PendingInputActionsExt inputActionExt = new PendingInputActionsExt();
        String inputId = inputStepExecution.getId();
        inputActionExt.setId(inputId);
        inputActionExt.setProceedText(inputStepExecution.getInput().getOk());
        inputActionExt.setMessage(inputStepExecution.getInput().getMessage());
        String runUrl = ModelUtil.getFullItemUrl(run.getUrl());
        inputActionExt.setInputs(PendingInputActionsExt.getInputParams(inputId, run));
        inputActionExt.setProceedUrl(RunAPI.getInputStepSubmitUrl(run, inputId));
        inputActionExt.setAbortUrl(runUrl + "input/" + inputId + "/abort");
        inputActionExt.setRedirectApprovalUrl(runUrl + "input/");
        return inputActionExt;
    }

    private static List<InputParameterDefExt> getInputParams(String inputId, WorkflowRun run) {
        InputStepExecution execution;
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        if (inputAction != null && (execution = inputAction.getExecution(inputId)) != null) {
            List inputParamDefs = execution.getInput().getParameters();
            ArrayList<InputParameterDefExt> inputParameters = new ArrayList<InputParameterDefExt>();
            for (ParameterDefinition inputParamDef : inputParamDefs) {
                inputParameters.add(new InputParameterDefExt(inputParamDef));
            }
            return inputParameters;
        }
        return Collections.emptyList();
    }
}

