/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.rest.endpoints.JobAPI;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.hal.Link;
import com.cloudbees.workflow.rest.hal.Links;
import com.fasterxml.jackson.annotation.JsonInclude;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class JobExt {
    public static final int MAX_RUNS_PER_JOB = Integer.getInteger(JobExt.class.getName() + ".maxRunsPerJob", 10);
    private JobLinks _links;
    private String name;
    private int runCount;

    public JobLinks get_links() {
        return this._links;
    }

    public void set_links(JobLinks _links) {
        this._links = _links;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRunCount() {
        return this.runCount;
    }

    public void setRunCount(int runCount) {
        this.runCount = runCount;
    }

    public static JobExt create(WorkflowJob job) {
        JobExt jobExt = new JobExt();
        jobExt.set_links((JobLinks)new JobLinks().initSelf(JobAPI.getDescribeUrl(job)));
        jobExt.get_links().setRuns(Link.newLink(JobAPI.getRunsUrl(job)));
        jobExt.setName(job.getName());
        jobExt.setRunCount(JobExt.countRuns(job));
        return jobExt;
    }

    private static int countRuns(WorkflowJob job) {
        int count = 0;
        RunList runs = job.getBuilds();
        for (WorkflowRun run : runs) {
            ++count;
        }
        return count;
    }

    @Deprecated
    public static List<RunExt> create(List<WorkflowRun> runs) {
        return JobExt.create(runs, null);
    }

    @Deprecated
    public static List<RunExt> create(List<WorkflowRun> runs, String since) {
        return JobExt.create(runs, since, false);
    }

    public static List<RunExt> create(List<WorkflowRun> runs, String since, boolean fullStages) {
        if (since != null && (since = since.trim()).length() == 0) {
            since = null;
        }
        ArrayList<RunExt> runsExt = new ArrayList<RunExt>();
        for (WorkflowRun run : runs) {
            RunExt runExt = fullStages ? RunExt.create(run) : RunExt.create(run).createWrapper();
            runsExt.add(runExt);
            if ((since == null || !runExt.getName().equals(since)) && runsExt.size() <= MAX_RUNS_PER_JOB) continue;
            break;
        }
        return runsExt;
    }

    public static final class JobLinks
    extends Links {
        private Link runs;

        public Link getRuns() {
            return this.runs;
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setRuns(Link runs) {
            this.runs = runs;
        }
    }
}

