/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.flownode.FlowNodeUtil;
import com.cloudbees.workflow.rest.endpoints.flownode.Describe;
import com.cloudbees.workflow.rest.external.ErrorExt;
import com.cloudbees.workflow.rest.external.ExecDuration;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.cloudbees.workflow.rest.hal.Link;
import com.cloudbees.workflow.rest.hal.Links;
import com.fasterxml.jackson.annotation.JsonInclude;
import hudson.model.Queue;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class FlowNodeExt {
    private FlowNodeLinks _links;
    private String id;
    private String name;
    private String execNode;
    private StatusExt status;
    private ErrorExt error;
    private long startTimeMillis;
    private long durationMillis;
    private long pauseDurationMillis;

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FlowNodeLinks get_links() {
        return this._links;
    }

    public void set_links(FlowNodeLinks _links) {
        this._links = _links;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExecNode() {
        return this.execNode;
    }

    public void setExecNode(String execNode) {
        this.execNode = execNode;
    }

    public StatusExt getStatus() {
        return this.status;
    }

    public void setStatus(StatusExt status) {
        this.status = status;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ErrorExt getError() {
        return this.error;
    }

    public void setError(ErrorExt error) {
        this.error = error;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public void setStartTimeMillis(long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public long getPauseDurationMillis() {
        return this.pauseDurationMillis;
    }

    public void setPauseDurationMillis(long pauseDurationMillis) {
        this.pauseDurationMillis = pauseDurationMillis;
    }

    public static FlowNodeExt create(FlowNode node) {
        FlowNodeExt flowNodeExt = new FlowNodeExt();
        flowNodeExt.addBasicNodeData(node);
        return flowNodeExt;
    }

    public static FlowNodeExt create(FlowNode node, String execNodeName, ExecDuration duration, long startTimeMillis, StatusExt status, ErrorAction error) {
        FlowNodeExt flowNodeExt = new FlowNodeExt();
        flowNodeExt.addBasicNodeData(node, execNodeName, duration, startTimeMillis, status, error);
        return flowNodeExt;
    }

    protected void calculateTimings(FlowNode node) {
        if (this.getStatus() != StatusExt.NOT_EXECUTED) {
            try {
                WorkflowRun run;
                TimingInfo ti;
                Queue.Executable exec = node.getExecution().getOwner().getExecutable();
                if (exec instanceof WorkflowRun && (ti = StatusAndTiming.computeChunkTiming((WorkflowRun)(run = (WorkflowRun)exec), (long)PauseAction.getPauseDuration((FlowNode)node), (FlowNode)node, (FlowNode)node, (FlowNode)FlowNodeUtil.getNodeAfter(node))) != null) {
                    this.setStartTimeMillis(ti.getStartTimeMillis());
                    this.setPauseDurationMillis(ti.getPauseDurationMillis());
                    this.setDurationMillis(ti.getTotalDurationMillis());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addBasicNodeData(FlowNode node, String execNodeName, ExecDuration duration, long startTimeMillis, StatusExt status, ErrorAction error) {
        this.setId(node.getId());
        this.setName(node.getDisplayName());
        this.setExecNode(execNodeName);
        this.set_links(new FlowNodeLinks());
        this.get_links().initSelf(Describe.getUrl(node));
        this.setStatus(status);
        if (status != StatusExt.NOT_EXECUTED && error != null) {
            this.setError(ErrorExt.create(error));
        }
        this.setStartTimeMillis(startTimeMillis);
        if (duration != null) {
            this.setPauseDurationMillis(duration.getPauseDurationMillis());
            this.setDurationMillis(duration.getTotalDurationMillis());
        }
    }

    protected void addBasicNodeData(@Nonnull FlowNode node) {
        boolean isExecuted = NotExecutedNodeAction.isExecuted((FlowNode)node);
        StatusExt status = null;
        ErrorAction errorAction = null;
        if (isExecuted) {
            errorAction = node.getError();
            status = StatusExt.valueOf(errorAction);
        } else {
            status = StatusExt.NOT_EXECUTED;
        }
        this.addBasicNodeData(node, "", null, 0L, status, errorAction);
        this.calculateTimings(node);
    }

    public String toString() {
        return "FlowNodeExt[id=" + this.getId() + ",name=" + this.getName() + "]";
    }

    public static final class FlowNodeLinks
    extends Links {
        private Link log;

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Link getLog() {
            return this.log;
        }

        public void setLog(Link log) {
            this.log = log;
        }
    }
}

