/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.rest.external.AtomFlowNodeExt;
import com.cloudbees.workflow.rest.external.ExecDuration;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class ChunkVisitor
extends StandardChunkVisitor {
    ArrayDeque<StageNodeExt> stages = new ArrayDeque();
    FlowNode firstExecuted = null;
    ArrayDeque<AtomFlowNodeExt> stageContents = new ArrayDeque();
    WorkflowRun run;
    ArrayList<String> stageNodeIds = new ArrayList();

    public ChunkVisitor(@Nonnull WorkflowRun run) {
        this.run = run;
    }

    public Collection<StageNodeExt> getStages() {
        return this.stages;
    }

    public static AtomFlowNodeExt makeAtomNode(@Nonnull WorkflowRun run, @CheckForNull FlowNode beforeNode, @Nonnull FlowNode node, @CheckForNull FlowNode next) {
        if (!(node instanceof AtomNode)) {
            return null;
        }
        long pause = PauseAction.getPauseDuration((FlowNode)node);
        TimingInfo times = StatusAndTiming.computeChunkTiming((WorkflowRun)run, (long)pause, (FlowNode)node, (FlowNode)node, (FlowNode)next);
        ExecDuration dur = times == null ? new ExecDuration() : new ExecDuration(times);
        GenericStatus status = StatusAndTiming.computeChunkStatus((WorkflowRun)run, (FlowNode)beforeNode, (FlowNode)node, (FlowNode)node, (FlowNode)next);
        if (status == null) {
            status = GenericStatus.NOT_EXECUTED;
        }
        ErrorAction err = node.getError();
        if (status == GenericStatus.FAILURE && err == null) {
            err = new ErrorAction(new Throwable("Build marked as a failure, final stage will fail."));
        }
        AtomFlowNodeExt output = AtomFlowNodeExt.create(node, "", dur, TimingAction.getStartTime((FlowNode)node), StatusExt.fromGenericStatus(status), err);
        return output;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="We can actually get nulls")
    protected void handleChunkDone(@Nonnull MemoryFlowChunk chunk) {
        GenericStatus status;
        TimingInfo times;
        StageNodeExt stageExt = new StageNodeExt();
        if (this.firstExecuted != null) {
            FlowNode last = chunk.getLastNode() != null ? chunk.getLastNode() : chunk.getFirstNode();
            times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)chunk.getPauseTimeMillis(), (FlowNode)this.firstExecuted, (FlowNode)last, (FlowNode)chunk.getNodeAfter());
        } else {
            times = new TimingInfo(0L, 0L, this.run.getStartTimeInMillis());
        }
        ExecDuration dur = times == null ? new ExecDuration() : new ExecDuration(times);
        long startTime = 0L;
        if (this.firstExecuted == null) {
            status = GenericStatus.NOT_EXECUTED;
        } else {
            status = StatusAndTiming.computeChunkStatus((WorkflowRun)this.run, (FlowNode)chunk.getNodeBefore(), (FlowNode)this.firstExecuted, (FlowNode)chunk.getLastNode(), (FlowNode)chunk.getNodeAfter());
            startTime = TimingAction.getStartTime((FlowNode)this.firstExecuted);
        }
        stageExt.addBasicNodeData(chunk.getFirstNode(), "", dur, startTime, StatusExt.fromGenericStatus(status), chunk.getLastNode().getError());
        int childNodeLength = Math.min(StageNodeExt.MAX_CHILD_NODES, this.stageContents.size());
        ArrayList<AtomFlowNodeExt> internals = new ArrayList<AtomFlowNodeExt>(childNodeLength);
        Iterables.addAll(internals, (Iterable)Iterables.limit(this.stageContents, (int)StageNodeExt.MAX_CHILD_NODES));
        stageExt.setStageFlowNodes(internals);
        stageExt.allChildNodeIds = new ArrayList<String>(Lists.reverse(this.stageNodeIds));
        this.stages.push(stageExt);
    }

    protected void resetChunk(@Nonnull MemoryFlowChunk chunk) {
        super.resetChunk(chunk);
        this.firstExecuted = null;
        this.stageNodeIds.clear();
        this.stageContents.clear();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="We can actually get nulls")
    public void chunkStart(@Nonnull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @Nonnull ForkScanner scanner) {
        if (NotExecutedNodeAction.isExecuted((FlowNode)startNode)) {
            this.firstExecuted = startNode;
        }
        if (this.chunk.getLastNode() == null) {
            this.chunk.setLastNode(startNode);
        }
        super.chunkStart(startNode, beforeBlock, scanner);
    }

    public void chunkEnd(@Nonnull FlowNode endNode, @CheckForNull FlowNode afterBlock, @Nonnull ForkScanner scanner) {
        super.chunkEnd(endNode, afterBlock, scanner);
        this.stageContents.clear();
        this.stageNodeIds.clear();
        this.chunk.setPauseTimeMillis(0L);
        this.firstExecuted = null;
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterBlock, scanner);
        }
    }

    public void atomNode(@CheckForNull FlowNode before, @Nonnull FlowNode atomNode, @CheckForNull FlowNode after, @Nonnull ForkScanner scan) {
        if (NotExecutedNodeAction.isExecuted((FlowNode)atomNode)) {
            this.firstExecuted = atomNode;
        }
        long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
        this.chunk.setPauseTimeMillis(this.chunk.getPauseTimeMillis() + pause);
        AtomFlowNodeExt ext = ChunkVisitor.makeAtomNode(this.run, before, atomNode, after);
        if (ext != null) {
            this.stageContents.push(ext);
        }
        this.stageNodeIds.add(atomNode.getId());
    }
}

