/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.external;

import com.cloudbees.workflow.rest.endpoints.flownode.Log;
import com.cloudbees.workflow.rest.external.ExecDuration;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.cloudbees.workflow.rest.hal.Link;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.kohsuke.stapler.Stapler;

public class AtomFlowNodeExt
extends FlowNodeExt {
    private List<String> parentNodes = new ArrayList<String>();

    public List<String> getParentNodes() {
        return this.parentNodes;
    }

    public void setParentNodes(List<String> parentNodes) {
        this.parentNodes = parentNodes;
    }

    public static AtomFlowNodeExt create(FlowNode node) {
        AtomFlowNodeExt flowNodeExt = new AtomFlowNodeExt();
        flowNodeExt.addBasicNodeData(node);
        if (flowNodeExt.getStatus() != StatusExt.NOT_EXECUTED && node.getAction(LogAction.class) != null) {
            flowNodeExt.get_links().setLog(Link.newLink(Log.getUrl(node)));
        }
        flowNodeExt.addParentNodeRefs(node);
        return flowNodeExt;
    }

    public static AtomFlowNodeExt create(FlowNode node, String execNodeName, ExecDuration duration, long startTimeMillis, StatusExt status, @CheckForNull ErrorAction error) {
        AtomFlowNodeExt basic = new AtomFlowNodeExt();
        basic.addBasicNodeData(node, execNodeName, duration, startTimeMillis, status, error);
        if (basic.getStatus() != StatusExt.NOT_EXECUTED && Stapler.getCurrentRequest() != null && node.getAction(LogAction.class) != null) {
            basic.get_links().setLog(Link.newLink(Log.getUrl(node)));
        }
        basic.addParentNodeRefs(node);
        return basic;
    }

    private void addParentNodeRefs(FlowNode node) {
        List parents = node.getParents();
        if (parents != null && !parents.isEmpty()) {
            for (FlowNode parent : parents) {
                this.getParentNodes().add(parent.getId());
            }
        }
    }
}

