/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.rest.endpoints;

import com.cloudbees.workflow.rest.AbstractWorkflowRunActionHandler;
import com.cloudbees.workflow.rest.external.BuildArtifactExt;
import com.cloudbees.workflow.rest.external.ChangeSetExt;
import com.cloudbees.workflow.rest.external.PendingInputActionsExt;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.util.ModelUtil;
import com.cloudbees.workflow.util.ServeJson;
import hudson.Extension;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class RunAPI
extends AbstractWorkflowRunActionHandler {
    public static String getUrl(WorkflowRun run) {
        return ModelUtil.getFullItemUrl(run.getUrl()) + "wfapi" + "/";
    }

    public static String getDescribeUrl(WorkflowRun run) {
        return RunAPI.getUrl(run) + "describe";
    }

    public static String getChangeSetsUrl(WorkflowRun run) {
        return RunAPI.getUrl(run) + "changesets";
    }

    public static String getPendingInputActionsUrl(WorkflowRun run) {
        return RunAPI.getUrl(run) + "pendingInputActions";
    }

    public static String getNextPendingInputActionUrl(WorkflowRun run) {
        return RunAPI.getUrl(run) + "nextPendingInputAction";
    }

    public static String getArtifactsUrl(WorkflowRun run) {
        return RunAPI.getUrl(run) + "artifacts";
    }

    public static String getInputStepSubmitUrl(WorkflowRun run, String inputId) {
        return RunAPI.getUrl(run) + "inputSubmit?inputId=" + inputId;
    }

    public static String getArtifactUrl(WorkflowRun run, Run.Artifact artifact) {
        return ModelUtil.getFullItemUrl(run.getUrl()) + "artifact/" + artifact.getHref();
    }

    @ServeJson
    @Restricted(value={DoNotUse.class})
    public RunExt doIndex() {
        return this.doDescribe();
    }

    @ServeJson
    @Restricted(value={DoNotUse.class})
    public RunExt doDescribe() {
        return RunExt.create(this.getRun()).createWrapper();
    }

    @ServeJson
    @Restricted(value={DoNotUse.class})
    public List<ChangeSetExt> doChangesets() {
        ArrayList<ChangeSetExt> changeSetExts = new ArrayList<ChangeSetExt>();
        List changesets = this.getRun().getChangeSets();
        for (ChangeLogSet changeset : changesets) {
            changeSetExts.add(ChangeSetExt.create((ChangeLogSet<? extends ChangeLogSet.Entry>)changeset, this.getRun()));
        }
        return changeSetExts;
    }

    @ServeJson
    @Restricted(value={DoNotUse.class})
    public List<PendingInputActionsExt> doPendingInputActions() {
        List executions;
        ArrayList<PendingInputActionsExt> pendingInputActions = new ArrayList<PendingInputActionsExt>();
        InputAction inputAction = (InputAction)this.getRun().getAction(InputAction.class);
        if (inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty()) {
            for (InputStepExecution inputStepExecution : executions) {
                pendingInputActions.add(PendingInputActionsExt.create(inputStepExecution, this.getRun()));
            }
        }
        return pendingInputActions;
    }

    @ServeJson
    @Restricted(value={DoNotUse.class})
    public PendingInputActionsExt doNextPendingInputAction() {
        List executions;
        InputAction inputAction = (InputAction)this.getRun().getAction(InputAction.class);
        if (inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty()) {
            for (InputStepExecution inputStepExecution : executions) {
                if (inputStepExecution.isSettled()) continue;
                return PendingInputActionsExt.create(inputStepExecution, this.getRun());
            }
        }
        return null;
    }

    @ServeJson
    @Restricted(value={DoNotUse.class})
    public List<BuildArtifactExt> doArtifacts() {
        ArrayList<BuildArtifactExt> artifactExts = new ArrayList<BuildArtifactExt>();
        List artifacts = this.getRun().getArtifacts();
        if (artifacts != null && !artifacts.isEmpty()) {
            for (Run.Artifact artifact : artifacts) {
                artifactExts.add(BuildArtifactExt.create(artifact, this.getRun()));
            }
        }
        return artifactExts;
    }

    @RequirePOST
    @ServeJson
    @Restricted(value={DoNotUse.class})
    public void doInputSubmit(@QueryParameter String inputId) throws ServletException {
        InputAction inputAction = (InputAction)this.getRun().getAction(InputAction.class);
        if (inputAction == null) {
            throw new ServletException("Error processing Input Submit request. This Run instance does not have an InputAction.");
        }
        InputStepExecution execution = inputAction.getExecution(inputId);
        if (execution == null) {
            throw new ServletException(String.format("Error processing Input Submit request. This Run instance does not have an Input with an ID of '%s'. The input ID may not be pre-normalized appropriately.", inputId));
        }
        try {
            execution.doProceed(Stapler.getCurrentRequest());
        }
        catch (Exception e) {
            throw new ServletException("Error processing Input Submit request.", (Throwable)e);
        }
    }
}

