/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.workflow.flownode;

import com.cloudbees.workflow.rest.external.JobExt;
import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.listeners.ItemListener;
import hudson.util.RunList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class FlowNodeUtil {
    private static final Logger LOGGER = Logger.getLogger(FlowNodeUtil.class.getName());
    private static final List<CacheExtension> FALLBACK_CACHES = Arrays.asList(new CacheExtension());

    private FlowNodeUtil() {
    }

    @CheckForNull
    public static RunExt getCachedRun(@Nonnull WorkflowRun run) {
        RunExt cachedRun = (RunExt)CacheExtension.all().get(0).getRunCache().getIfPresent((Object)run.getExternalizableId());
        if (cachedRun != null) {
            return cachedRun;
        }
        return null;
    }

    public static void cacheRun(WorkflowRun run, RunExt runExt) {
        if (!run.isBuilding()) {
            CacheExtension.all().get(0).getRunCache().put((Object)run.getExternalizableId(), (Object)runExt);
        }
    }

    public static boolean isNotPartOfRunningBuild(FlowExecution execution) {
        return execution != null && execution.isComplete();
    }

    @CheckForNull
    public static FlowNode getNodeAfter(final @Nonnull FlowNode node) {
        if (node.isRunning() || node instanceof FlowEndNode) {
            return null;
        }
        FlowNode nextNode = null;
        FlowExecution exec = node.getExecution();
        int iota = 0;
        try {
            iota = Integer.parseInt(node.getId());
            nextNode = exec.getNode(Integer.toString(iota + 1));
            if (nextNode != null && nextNode.getParents().contains(node)) {
                return nextNode;
            }
        }
        catch (IOException ioe) {
            try {
                nextNode = exec.getNode(Integer.toString(iota + 2));
                if (nextNode != null && nextNode.getParents().contains(node)) {
                    return nextNode;
                }
            }
            catch (IOException iOException) {}
        }
        catch (NumberFormatException ioe) {
            // empty catch block
        }
        FlowNode after = new ForkScanner().findFirstMatch((Collection)node.getExecution().getCurrentHeads(), Collections.singletonList(node), (Predicate)new Predicate<FlowNode>(){

            public boolean apply(@Nonnull FlowNode f) {
                List parents = f.getParents();
                return parents.contains(node);
            }
        });
        return after;
    }

    public static boolean isPauseNode(FlowNode flowNode) {
        return PauseAction.isPaused((FlowNode)flowNode);
    }

    public static StatusExt getStatus(FlowNode node) {
        boolean isExecuted = NotExecutedNodeAction.isExecuted((FlowNode)node);
        if (isExecuted) {
            ErrorAction errorAction = node.getError();
            return StatusExt.valueOf(errorAction);
        }
        return StatusExt.NOT_EXECUTED;
    }

    @CheckForNull
    public static WorkflowRun getWorkflowRunForExecution(@CheckForNull FlowExecution exec) {
        if (exec == null) {
            return null;
        }
        try {
            Queue.Executable executable = exec.getOwner().getExecutable();
            if (executable instanceof WorkflowRun) {
                WorkflowRun myRun = (WorkflowRun)executable;
                return myRun;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Execution probably has not begun, or invalid pipeline data!", ioe);
        }
        return null;
    }

    @Nonnull
    public static List<FlowNode> getStageNodes(@CheckForNull FlowExecution execution) throws RuntimeException {
        WorkflowRun run = FlowNodeUtil.getWorkflowRunForExecution(execution);
        if (run == null) {
            return Collections.emptyList();
        }
        RunExt runExt = RunExt.create(run);
        if (runExt.getStages() != null) {
            ArrayList<FlowNode> nodes = new ArrayList<FlowNode>(runExt.getStages().size());
            try {
                for (StageNodeExt st : runExt.getStages()) {
                    nodes.add(execution.getNode(st.getId()));
                }
                return nodes;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to load flownode for valid run ", ioe);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<FlowNode> getStageNodes(@CheckForNull FlowNode stageNode) {
        if (stageNode == null) {
            return Collections.emptyList();
        }
        FlowExecution exec = stageNode.getExecution();
        WorkflowRun run = FlowNodeUtil.getWorkflowRunForExecution(exec);
        if (run == null) {
            return Collections.emptyList();
        }
        RunExt runExt = RunExt.create(run);
        if (runExt.getStages() == null || runExt.getStages().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> childIds = null;
        for (StageNodeExt st : runExt.getStages()) {
            if (!st.getId().equals(stageNode.getId())) continue;
            childIds = st.getAllChildNodeIds();
            break;
        }
        try {
            if (childIds == null) {
                return Collections.emptyList();
            }
            ArrayList<FlowNode> nodes = new ArrayList<FlowNode>(childIds.size());
            for (String s : childIds) {
                nodes.add(exec.getNode(s));
            }
            return nodes;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to load a FlowNode, even though run exists! ", ioe);
        }
    }

    public static void dumpNodes(List<FlowNode> nodeList) {
        System.out.println("------------------------------------------------------------------------------------------");
        for (FlowNode node : nodeList) {
            System.out.println("[" + node.getId() + "][" + TimingAction.getStartTime((FlowNode)node) + "] " + node.getDisplayName());
        }
        System.out.println("------------------------------------------------------------------------------------------");
    }

    @Extension
    public static class RenameHandler
    extends ItemListener {
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            CacheExtension ext = CacheExtension.all().get(0);
            Cache<String, RunExt> rc = ext.getRunCache();
            if (item instanceof WorkflowJob) {
                RunList runs = ((WorkflowJob)item).getBuilds().limit(JobExt.MAX_RUNS_PER_JOB + 5);
                for (WorkflowRun r : runs) {
                    String path;
                    RunExt cachedRun;
                    if (r.isBuilding() || (cachedRun = (RunExt)rc.getIfPresent((Object)(path = oldFullName + "#" + r.getId()))) == null) continue;
                    rc.invalidate((Object)path);
                    rc.put((Object)(newFullName + "#" + r.getId()), (Object)cachedRun);
                }
            }
        }

        public void onDeleted(Item item) {
            CacheExtension ext = CacheExtension.all().get(0);
            if (item instanceof WorkflowJob) {
                RunList runs = ((WorkflowJob)item).getBuilds();
                for (WorkflowRun r : runs) {
                    ext.getRunCache().invalidate((Object)r.getExternalizableId());
                }
            }
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class CacheExtension
    extends CacheExtensionPoint {
        protected final Cache<String, RunExt> runData = CacheBuilder.newBuilder().maximumSize(1000L).build();

        @Override
        public Cache<String, RunExt> getRunCache() {
            return this.runData;
        }

        public static List<CacheExtension> all() {
            Jenkins myJenkins = Jenkins.getInstance();
            if (myJenkins == null) {
                return FALLBACK_CACHES;
            }
            return myJenkins.getExtensionList(CacheExtension.class);
        }
    }

    public static abstract class CacheExtensionPoint
    implements ExtensionPoint {
        public abstract Cache<String, RunExt> getRunCache();
    }
}

