/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.storage;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.util.RobustReflectionConverter;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.actions.FlowNodeAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.support.storage.FlowNodeStorage;

public class SimpleXStreamFlowNodeStorage
extends FlowNodeStorage {
    private final File dir;
    private final FlowExecution exec;
    private final LoadingCache<String, FlowNode> nodeCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<String, FlowNode>(){

        public FlowNode load(String key) throws Exception {
            return ((SimpleXStreamFlowNodeStorage)SimpleXStreamFlowNodeStorage.this).load((String)key).node;
        }
    });
    public static final XStream2 XSTREAM = new XStream2();
    private static final Field FlowNode$exec;
    private static final Field FlowNode$parents;
    private static final Field FlowNode$parentIds;

    public SimpleXStreamFlowNodeStorage(FlowExecution exec, File dir) {
        this.exec = exec;
        this.dir = dir;
    }

    @Override
    public FlowNode getNode(String id) throws IOException {
        try {
            return (FlowNode)this.nodeCache.get((Object)id);
        }
        catch (ExecutionException x) {
            throw new IOException(x);
        }
    }

    @Override
    public void storeNode(FlowNode n) throws IOException {
        this.nodeCache.put((Object)n.getId(), (Object)n);
        XmlFile f = this.getNodeFile(n.getId());
        if (!f.exists()) {
            f.write((Object)new Tag(n, Collections.emptyList()));
        }
    }

    private XmlFile getNodeFile(String id) {
        return new XmlFile((XStream)XSTREAM, new File(this.dir, id + ".xml"));
    }

    public List<Action> loadActions(FlowNode node) throws IOException {
        if (!this.getNodeFile(node.getId()).exists()) {
            return new ArrayList<Action>();
        }
        return this.load(node.getId()).actions();
    }

    public void saveActions(FlowNode node, List<Action> actions) throws IOException {
        this.getNodeFile(node.getId()).write((Object)new Tag(node, actions));
    }

    private Tag load(String id) throws IOException {
        XmlFile nodeFile = this.getNodeFile(id);
        Tag v = (Tag)nodeFile.read();
        if (v.node == null) {
            throw new IOException("failed to load flow node from " + nodeFile + ": " + nodeFile.asString());
        }
        try {
            FlowNode$exec.set(v.node, this.exec);
        }
        catch (IllegalAccessException e) {
            throw (IllegalAccessError)new IllegalAccessError("Failed to set owner").initCause(e);
        }
        for (FlowNodeAction a : Util.filter(v.actions(), FlowNodeAction.class)) {
            a.onLoad(v.node);
        }
        return v;
    }

    static {
        XSTREAM.registerConverter(new Converter(){
            private final RobustReflectionConverter ref = new RobustReflectionConverter(XSTREAM.getMapper(), JVM.newReflectionProvider());
            private final Map<FlowNode, String> ids = CacheBuilder.newBuilder().weakKeys().build().asMap();

            public boolean canConvert(Class type) {
                return FlowNode.class.isAssignableFrom(type);
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                this.ref.marshal(source, writer, context);
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                try {
                    FlowNode n;
                    block8: {
                        n = (FlowNode)this.ref.unmarshal(reader, context);
                        this.ids.put(n, reader.getValue());
                        try {
                            List parents = (List)FlowNode$parents.get(n);
                            if (parents != null) {
                                ArrayList<String> parentIds = (ArrayList<String>)FlowNode$parentIds.get(n);
                                assert (parentIds == null);
                                parentIds = new ArrayList<String>(parents.size());
                                for (FlowNode parent : parents) {
                                    String id = this.ids.get(parent);
                                    assert (id != null);
                                    parentIds.add(id);
                                }
                                FlowNode$parents.set(n, null);
                                FlowNode$parentIds.set(n, parentIds);
                            }
                        }
                        catch (Exception x) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)x);
                        }
                    }
                    return n;
                }
                catch (RuntimeException x) {
                    x.printStackTrace();
                    throw x;
                }
            }
        });
        try {
            FlowNode$exec = FlowNode.class.getDeclaredField("exec");
            FlowNode$exec.setAccessible(true);
            FlowNode$parents = FlowNode.class.getDeclaredField("parents");
            FlowNode$parents.setAccessible(true);
            FlowNode$parentIds = FlowNode.class.getDeclaredField("parentIds");
            FlowNode$parentIds.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    private static class Tag {
        final FlowNode node;
        @CheckForNull
        private final Action[] actions;

        private Tag(@Nonnull FlowNode node, @Nonnull List<Action> actions) {
            this.node = node;
            this.actions = actions.isEmpty() ? null : actions.toArray(new Action[actions.size()]);
        }

        @Nonnull
        public List<Action> actions() {
            return this.actions != null ? Arrays.asList(this.actions) : Collections.emptyList();
        }
    }
}

