/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import hudson.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import hudson.security.ACL;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;

public final class RunWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String externalizableId;
    private final boolean currentBuild;

    public RunWrapper(Run<?, ?> build, boolean currentBuild) {
        this.externalizableId = build.getExternalizableId();
        this.currentBuild = currentBuild;
    }

    @CheckForNull
    public Run<?, ?> getRawBuild() {
        return Run.fromExternalizableId((String)this.externalizableId);
    }

    @Nonnull
    private Run<?, ?> build() throws AbortException {
        Run<?, ?> r = this.getRawBuild();
        if (r == null) {
            throw new AbortException("No build record " + this.externalizableId + " could be located.");
        }
        return r;
    }

    @Whitelisted
    public void setResult(String result) throws AbortException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the result property on the current build");
        }
        this.build().setResult(Result.fromString((String)result));
    }

    @Whitelisted
    public void setDescription(String d) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the description property on the current build");
        }
        SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            this.build().setDescription(d);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
    }

    @Whitelisted
    public void setDisplayName(String n) throws IOException {
        if (!this.currentBuild) {
            throw new SecurityException("can only set the displayName property on the current build");
        }
        SecurityContext orig = ACL.impersonate((Authentication)ACL.SYSTEM);
        try {
            this.build().setDisplayName(n);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)orig);
        }
    }

    @Whitelisted
    public int getNumber() throws AbortException {
        return this.build().getNumber();
    }

    @Whitelisted
    @CheckForNull
    public String getResult() throws AbortException {
        Result result = this.build().getResult();
        return result != null ? result.toString() : null;
    }

    @Whitelisted
    public long getTimeInMillis() throws AbortException {
        return this.build().getTimeInMillis();
    }

    @Whitelisted
    public long getStartTimeInMillis() throws AbortException {
        return this.build().getStartTimeInMillis();
    }

    @Whitelisted
    public long getDuration() throws AbortException {
        return this.build().getDuration();
    }

    @Whitelisted
    public String getDescription() throws AbortException {
        return this.build().getDescription();
    }

    @Whitelisted
    public String getDisplayName() throws AbortException {
        return this.build().getDisplayName();
    }

    @Whitelisted
    public String getFullDisplayName() throws AbortException {
        return this.build().getFullDisplayName();
    }

    @Whitelisted
    public String getProjectName() throws AbortException {
        return this.build().getParent().getName();
    }

    @Whitelisted
    public String getFullProjectName() throws AbortException {
        return this.build().getParent().getFullName();
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getPreviousBuild() throws AbortException {
        Run previousBuild = this.build().getPreviousBuild();
        return previousBuild != null ? new RunWrapper(previousBuild, false) : null;
    }

    @Whitelisted
    @CheckForNull
    public RunWrapper getNextBuild() throws AbortException {
        Run nextBuild = this.build().getNextBuild();
        return nextBuild != null ? new RunWrapper(nextBuild, false) : null;
    }

    @Whitelisted
    public String getId() throws AbortException {
        return this.build().getId();
    }

    @Whitelisted
    @Nonnull
    public Map<String, String> getBuildVariables() throws AbortException {
        Run<?, ?> build = this.build();
        if (build instanceof AbstractBuild) {
            return Collections.unmodifiableMap(((AbstractBuild)build).getBuildVariables());
        }
        EnvironmentAction.IncludingOverrides env = (EnvironmentAction.IncludingOverrides)build.getAction(EnvironmentAction.IncludingOverrides.class);
        if (env != null) {
            return env.getOverriddenEnvironment();
        }
        return Collections.emptyMap();
    }

    @Whitelisted
    @Nonnull
    public String getAbsoluteUrl() throws AbortException {
        return this.build().getAbsoluteUrl();
    }

    @Whitelisted
    public List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() throws Exception {
        Run<?, ?> build = this.build();
        try {
            return (List)build.getClass().getMethod("getChangeSets", new Class[0]).invoke(build, new Object[0]);
        }
        catch (NoSuchMethodException x) {
            return Collections.emptyList();
        }
    }
}

