/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles.serialization;

import hudson.ExtensionList;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.pickles.PickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryCapsule;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryOwner;

public class RiverWriter
implements Closeable {
    private final File file;
    private final FlowExecutionOwner owner;
    private final DataOutputStream dout;
    private final Marshaller marshaller;
    private final int ephemeralsBackptr;
    private boolean pickling;
    List<Pickle> pickles = new ArrayList<Pickle>();
    static final long HEADER = 7330745437582215633L;
    static final int VERSION = 1;

    public RiverWriter(File f, FlowExecutionOwner _owner) throws IOException {
        final ExtensionList pickleFactories = PickleFactory.all();
        if (pickleFactories.isEmpty()) {
            throw new IllegalStateException("JENKINS-26137: Jenkins is shutting down");
        }
        this.file = f;
        this.owner = _owner;
        this.dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        this.dout.writeLong(7330745437582215633L);
        this.dout.writeShort(1);
        this.ephemeralsBackptr = this.dout.size();
        this.dout.writeInt(0);
        MarshallingConfiguration config = new MarshallingConfiguration();
        config.setObjectResolver(new ObjectResolver(){

            public Object readResolve(Object o) {
                throw new IllegalStateException();
            }

            public Object writeReplace(Object o) {
                if (o == RiverWriter.this.owner) {
                    return new DryOwner();
                }
                if (RiverWriter.this.pickling) {
                    for (PickleFactory f : pickleFactories) {
                        Pickle v = f.writeReplace(o);
                        if (v == null) continue;
                        RiverWriter.this.pickles.add(v);
                        return new DryCapsule(RiverWriter.this.pickles.size() - 1);
                    }
                }
                return o;
            }
        });
        this.marshaller = new RiverMarshallerFactory().createMarshaller(config);
        this.marshaller.start(Marshalling.createByteOutput((OutputStream)this.dout));
        this.pickling = true;
    }

    public void writeObject(Object o) throws IOException {
        this.marshaller.writeObject(o);
    }

    public ObjectOutput getObjectOutput() {
        return this.marshaller;
    }

    @Override
    public void close() throws IOException {
        this.marshaller.finish();
        int ephemeralsOffset = this.dout.size();
        this.pickling = false;
        this.marshaller.start(Marshalling.createByteOutput((OutputStream)this.dout));
        this.marshaller.writeObject(this.pickles);
        this.marshaller.finish();
        this.dout.close();
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "rw");){
            raf.seek(this.ephemeralsBackptr);
            raf.writeInt(ephemeralsOffset);
        }
    }
}

