/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.pickles.serialization;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.jboss.marshalling.ChainingObjectResolver;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.SimpleClassResolver;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.concurrent.Futures;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.DryOwner;
import org.jenkinsci.plugins.workflow.support.pickles.serialization.PickleResolver;

public class RiverReader
implements Closeable {
    private final File file;
    private final ClassLoader classLoader;
    private final FlowExecutionOwner owner;
    private ObjectResolver ownerResolver = new ObjectResolver(){

        public Object readResolve(Object replacement) {
            if (replacement instanceof DryOwner) {
                return RiverReader.this.owner;
            }
            return replacement;
        }

        public Object writeReplace(Object original) {
            throw new IllegalStateException();
        }
    };
    private InputStream in;

    public RiverReader(File f, ClassLoader classLoader, FlowExecutionOwner owner) throws IOException {
        this.file = f;
        this.classLoader = classLoader;
        this.owner = owner;
    }

    private int parseHeader(DataInputStream din) throws IOException {
        if (din.readLong() != 7330745437582215633L) {
            throw new IOException("Invalid stream header");
        }
        short v = din.readShort();
        if (v != 1) {
            throw new IOException("Unexpected stream version: " + v);
        }
        return din.readInt();
    }

    @Deprecated
    public ListenableFuture<Unmarshaller> restorePickles() throws IOException {
        return this.restorePickles(new ArrayList());
    }

    public ListenableFuture<Unmarshaller> restorePickles(Collection<ListenableFuture<?>> pickleFutures) throws IOException {
        this.in = this.openStreamAt(0);
        try {
            DataInputStream din = new DataInputStream(this.in);
            int offset = this.parseHeader(din);
            List<Pickle> pickles = this.readPickles(offset);
            PickleResolver evr = new PickleResolver(pickles, this.owner);
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)new SimpleClassResolver(this.classLoader));
            config.setObjectResolver(this.combine(evr, this.ownerResolver));
            final Unmarshaller eu = new RiverMarshallerFactory().createUnmarshaller(config);
            eu.start(Marshalling.createByteInput((InputStream)din));
            return Futures.transform(evr.rehydrate(pickleFutures), new Function<PickleResolver, Unmarshaller>(){

                public Unmarshaller apply(PickleResolver input) {
                    return eu;
                }
            });
        }
        catch (IOException x) {
            this.in.close();
            throw x;
        }
    }

    /*
     * Loose catch block
     */
    private List<Pickle> readPickles(int offset) throws IOException {
        BufferedInputStream es = this.openStreamAt(offset);
        try {
            MarshallingConfiguration config = new MarshallingConfiguration();
            config.setClassResolver((ClassResolver)new SimpleClassResolver(this.classLoader));
            config.setObjectResolver(this.ownerResolver);
            Unmarshaller eu = new RiverMarshallerFactory().createUnmarshaller(config);
            try {
                eu.start(Marshalling.createByteInput((InputStream)es));
                List list = (List)eu.readObject();
                return list;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Failed to read the stream", e);
            }
            finally {
                eu.finish();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)es);
        }
    }

    private BufferedInputStream openStreamAt(int offset) throws IOException {
        FileInputStream in = new FileInputStream(this.file);
        IOUtils.skipFully((InputStream)in, (long)offset);
        return new BufferedInputStream(in);
    }

    private ObjectResolver combine(ObjectResolver ... resolvers) {
        return new ChainingObjectResolver(resolvers);
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException x) {
                Logger.getLogger(RiverReader.class.getName()).log(Level.WARNING, "could not close stream on " + this.file, x);
            }
        }
    }
}

