/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.support.concurrent.ChainingListenableFuture;
import org.jenkinsci.plugins.workflow.support.concurrent.ListFuture;

public abstract class Futures {
    public static <V> void addCallback(ListenableFuture<V> future, FutureCallback<? super V> callback) {
        Futures.addCallback(future, callback, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public static <V> void addCallback(final ListenableFuture<V> future, final FutureCallback<? super V> callback, Executor executor) {
        Preconditions.checkNotNull(callback);
        Runnable callbackListener = new Runnable(){

            @Override
            public void run() {
                try {
                    Object value = Uninterruptibles.getUninterruptibly((Future)future);
                    callback.onSuccess(value);
                }
                catch (ExecutionException e) {
                    callback.onFailure(e.getCause());
                }
                catch (RuntimeException e) {
                    callback.onFailure((Throwable)e);
                }
                catch (Error e) {
                    callback.onFailure((Throwable)e);
                }
            }
        };
        future.addListener(callbackListener, executor);
    }

    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        SettableFuture future = SettableFuture.create();
        future.set(value);
        return future;
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull((Object)throwable);
        SettableFuture future = SettableFuture.create();
        future.setException(throwable);
        return future;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> future, Function<? super I, ? extends O> function) {
        return Futures.transform(future, function, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> future, final Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        Function wrapperFunction = new Function<I, ListenableFuture<O>>(){

            public ListenableFuture<O> apply(I input) {
                Object output = function.apply(input);
                return Futures.immediateFuture(output);
            }
        };
        return Futures.chain(future, wrapperFunction, executor);
    }

    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... futures) {
        return new ListFuture(ImmutableList.copyOf((Object[])futures), true, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        return new ListFuture(ImmutableList.copyOf(futures), true, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Deprecated
    static <I, O> ListenableFuture<O> chain(ListenableFuture<I> input, final Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor executor) {
        Preconditions.checkNotNull(function);
        ChainingListenableFuture chain = new ChainingListenableFuture(new AsyncFunction<I, O>(){

            public ListenableFuture<O> apply(I input) {
                return (ListenableFuture)function.apply(input);
            }
        }, input);
        input.addListener(chain, executor);
        return chain;
    }
}

