/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.console.ConsoleLogFilter;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.actions.EnvironmentAction;
import org.jenkinsci.plugins.workflow.support.actions.LogActionImpl;

public abstract class DefaultStepContext
extends StepContext {
    private transient TaskListener listener;

    public final <T> T get(Class<T> key) throws IOException, InterruptedException {
        T value = this.doGet(key);
        if (key == EnvVars.class) {
            Run run = this.get(Run.class);
            EnvironmentAction a = (EnvironmentAction)run.getAction(EnvironmentAction.class);
            EnvVars customEnvironment = a != null ? a.getEnvironment() : run.getEnvironment(this.get(TaskListener.class));
            return key.cast(EnvironmentExpander.getEffectiveEnvironment((EnvVars)customEnvironment, (EnvVars)((EnvVars)value), (EnvironmentExpander)this.get(EnvironmentExpander.class)));
        }
        if (key == Launcher.class) {
            return key.cast(this.makeLauncher((Launcher)value));
        }
        if (value != null) {
            return value;
        }
        if (key == TaskListener.class) {
            if (this.listener == null) {
                this.listener = LogActionImpl.stream(this.getNode(), this.get(ConsoleLogFilter.class));
            }
            return key.cast(this.listener);
        }
        if (Node.class.isAssignableFrom(key)) {
            Computer c = this.get(Computer.class);
            Node n = null;
            if (c != null) {
                n = c.getNode();
            }
            return this.castOrNull(key, n);
        }
        if (Run.class.isAssignableFrom(key)) {
            return this.castOrNull(key, this.getExecution().getOwner().getExecutable());
        }
        if (Job.class.isAssignableFrom(key)) {
            return this.castOrNull(key, this.get(Run.class).getParent());
        }
        if (FlowExecution.class.isAssignableFrom(key)) {
            return this.castOrNull(key, this.getExecution());
        }
        return null;
    }

    private <T> T castOrNull(Class<T> key, Object o) {
        if (key.isInstance(o)) {
            return key.cast(o);
        }
        return null;
    }

    @CheckForNull
    private Launcher makeLauncher(@CheckForNull Launcher contextual) throws IOException, InterruptedException {
        LauncherDecorator decorator;
        Launcher launcher = contextual;
        Node n = this.get(Node.class);
        if (launcher == null) {
            if (n == null) {
                return null;
            }
            launcher = n.createLauncher(this.get(TaskListener.class));
        }
        if ((decorator = this.get(LauncherDecorator.class)) != null && n != null) {
            launcher = decorator.decorate(launcher, n);
        }
        return launcher;
    }

    @CheckForNull
    protected abstract <T> T doGet(Class<T> var1) throws IOException, InterruptedException;

    @Nonnull
    protected abstract FlowExecution getExecution() throws IOException;

    @Nonnull
    protected abstract FlowNode getNode() throws IOException;
}

