/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.AbstractFlowScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;

@NotThreadSafe
public class ForkScanner
extends AbstractFlowScanner {
    ArrayDeque<ParallelBlockStart> parallelBlockStartStack = new ArrayDeque();
    FlowNode currentParallelStartNode = null;
    ParallelBlockStart currentParallelStart = null;
    private boolean walkingFromFinish = false;
    NodeType currentType = null;
    NodeType nextType = null;
    private static Predicate<FlowNode> parallelStartPredicate = Predicates.alwaysFalse();

    @CheckForNull
    public NodeType getCurrentType() {
        return this.currentType;
    }

    @CheckForNull
    public NodeType getNextType() {
        return this.nextType;
    }

    public ForkScanner() {
    }

    public ForkScanner(@Nonnull Collection<FlowNode> heads) {
        this.setup(heads);
    }

    public ForkScanner(@Nonnull Collection<FlowNode> heads, @Nonnull Collection<FlowNode> blackList) {
        this.setup(heads, blackList);
    }

    @Override
    protected void reset() {
        this.parallelBlockStartStack.clear();
        this.currentParallelStart = null;
        this.currentParallelStartNode = null;
        this.myCurrent = null;
        this.myNext = null;
    }

    public static void setParallelStartPredicate(@Nonnull Predicate<FlowNode> pred) {
        parallelStartPredicate = pred;
    }

    public static boolean isParallelStart(@CheckForNull FlowNode f) {
        return parallelStartPredicate.apply((Object)f);
    }

    public static boolean isParallelEnd(@CheckForNull FlowNode f) {
        return f != null && f instanceof BlockEndNode && (f.getParents().size() > 1 || ForkScanner.isParallelStart(((BlockEndNode)f).getStartNode()));
    }

    public boolean isWalkingFromFinish() {
        return this.walkingFromFinish;
    }

    ArrayDeque<ParallelBlockStart> convertForksToBlockStarts(ArrayDeque<Fork> parallelForks) {
        ArrayDeque<ParallelBlockStart> output = new ArrayDeque<ParallelBlockStart>();
        for (Fork f : parallelForks) {
            ParallelBlockStart start = new ParallelBlockStart();
            start.forkStart = f.forkStart;
            start.unvisited = new ArrayDeque();
            for (FlowPiece fp : f.following) {
                if (!fp.isLeaf()) continue;
                start.unvisited.add(((FlowSegment)fp).visited.get(0));
            }
            output.add(start);
        }
        return output;
    }

    ArrayDeque<ParallelBlockStart> leastCommonAncestor(final @Nonnull Set<FlowNode> heads) {
        HashMap<FlowNode, FlowPiece> branches = new HashMap<FlowNode, FlowPiece>();
        ArrayList<Filterator<FlowNode>> iterators = new ArrayList<Filterator<FlowNode>>();
        ArrayList<FlowPiece> livePieces = new ArrayList<FlowPiece>();
        ArrayDeque<Fork> parallelForks = new ArrayDeque<Fork>();
        Predicate<FlowNode> notAHead = new Predicate<FlowNode>(){
            Collection<FlowNode> checkHeads;
            {
                this.checkHeads = ForkScanner.this.convertToFastCheckable(heads);
            }

            public boolean apply(FlowNode input) {
                return !this.checkHeads.contains((Object)input);
            }
        };
        for (FlowNode f : heads) {
            iterators.add(FlowScanningUtils.fetchEnclosingBlocks(f).filter(notAHead));
            FlowSegment b = new FlowSegment();
            b.add(f);
            livePieces.add(b);
            branches.put(f, b);
        }
        while (iterators.size() > 1) {
            ListIterator itIterator = iterators.listIterator();
            ListIterator<FlowSegment> pieceIterator = livePieces.listIterator();
            while (itIterator.hasNext()) {
                Filterator blockStartIterator = (Filterator)itIterator.next();
                FlowPiece myPiece = (FlowPiece)pieceIterator.next();
                if (!blockStartIterator.hasNext()) {
                    pieceIterator.remove();
                    itIterator.remove();
                    continue;
                }
                FlowNode nextBlockStart = (FlowNode)((Object)blockStartIterator.next());
                FlowPiece existingPiece = (FlowPiece)branches.get((Object)nextBlockStart);
                if (existingPiece == null && myPiece instanceof FlowSegment) {
                    ((FlowSegment)myPiece).add(nextBlockStart);
                    branches.put(nextBlockStart, myPiece);
                    continue;
                }
                if (existingPiece == null && myPiece instanceof Fork) {
                    FlowSegment newSegment = new FlowSegment();
                    newSegment.isLeaf = false;
                    newSegment.add(nextBlockStart);
                    newSegment.after = myPiece;
                    pieceIterator.remove();
                    pieceIterator.add(newSegment);
                    branches.put(nextBlockStart, newSegment);
                    continue;
                }
                if (existingPiece == null) continue;
                if (existingPiece instanceof Fork) {
                    ((Fork)existingPiece).following.add(myPiece);
                } else {
                    Fork f = ((FlowSegment)existingPiece).split(branches, (BlockStartNode)nextBlockStart, myPiece);
                    if (f.following.contains(existingPiece)) {
                        int headIndex = livePieces.indexOf(existingPiece);
                        livePieces.set(headIndex, f);
                    }
                    parallelForks.add(f);
                }
                itIterator.remove();
                pieceIterator.remove();
            }
        }
        return this.convertForksToBlockStarts(parallelForks);
    }

    @Override
    protected void setHeads(@Nonnull Collection<FlowNode> heads) {
        if (heads.size() > 1) {
            this.parallelBlockStartStack = this.leastCommonAncestor(new LinkedHashSet<FlowNode>(heads));
            this.currentParallelStart = this.parallelBlockStartStack.pop();
            this.currentParallelStartNode = this.currentParallelStart.forkStart;
            this.myNext = this.myCurrent = this.currentParallelStart.unvisited.pop();
            this.nextType = NodeType.PARALLEL_BRANCH_END;
            this.walkingFromFinish = false;
        } else {
            FlowNode f = heads.iterator().next();
            this.walkingFromFinish = f instanceof FlowEndNode;
            this.myCurrent = f;
            this.myNext = f;
            this.nextType = ForkScanner.isParallelEnd(f) ? NodeType.PARALLEL_END : (ForkScanner.isParallelStart(f) ? NodeType.PARALLEL_START : NodeType.NORMAL);
        }
        this.currentType = null;
    }

    @CheckForNull
    public FlowNode getCurrentParallelStartNode() {
        return this.currentParallelStartNode;
    }

    public int getParallelDepth() {
        return this.currentParallelStart == null ? 0 : 1 + this.parallelBlockStartStack.size();
    }

    FlowNode hitParallelEnd(BlockEndNode endNode, List<FlowNode> parents, Collection<FlowNode> blackList) {
        Object start = endNode.getStartNode();
        ArrayDeque<FlowNode> branches = new ArrayDeque<FlowNode>();
        for (FlowNode f : parents) {
            if (blackList.contains((Object)f)) continue;
            branches.addFirst(f);
        }
        FlowNode output = null;
        if (branches.size() > 0) {
            ParallelBlockStart parallelBlockStart = new ParallelBlockStart((BlockStartNode)((Object)start));
            output = (FlowNode)((Object)branches.pop());
            parallelBlockStart.unvisited = branches;
            if (this.currentParallelStart != null) {
                this.parallelBlockStartStack.push(this.currentParallelStart);
            }
            this.currentParallelStart = parallelBlockStart;
            this.currentParallelStartNode = start;
        }
        return output;
    }

    FlowNode hitParallelStart() {
        FlowNode output = null;
        if (this.currentParallelStart != null) {
            if (this.currentParallelStart.unvisited.isEmpty()) {
                output = this.currentParallelStartNode;
                if (this.parallelBlockStartStack.size() > 0) {
                    this.currentParallelStart = this.parallelBlockStartStack.pop();
                    this.currentParallelStartNode = this.currentParallelStart.forkStart;
                } else {
                    this.currentParallelStart = null;
                    this.currentParallelStartNode = null;
                }
            }
        } else {
            throw new IllegalStateException("Hit a BlockStartNode with multiple children, and no record of the start!");
        }
        return output != null && !this.myBlackList.contains((Object)output) ? output : null;
    }

    @Override
    public FlowNode next() {
        this.currentType = this.nextType;
        FlowNode output = super.next();
        return output;
    }

    @Override
    protected FlowNode next(@Nonnull FlowNode current, @Nonnull Collection<FlowNode> blackList) {
        FlowNode output = null;
        List<FlowNode> parents = current.getParents();
        if (!parents.isEmpty()) {
            if (parents.size() == 1) {
                FlowNode p = parents.get(0);
                if (p == this.currentParallelStartNode) {
                    FlowNode temp = this.hitParallelStart();
                    if (temp != null) {
                        this.nextType = NodeType.PARALLEL_START;
                        return temp;
                    }
                } else if (!blackList.contains((Object)p)) {
                    this.nextType = p instanceof BlockStartNode && p.getPersistentAction(ThreadNameAction.class) != null ? NodeType.PARALLEL_BRANCH_START : (ForkScanner.isParallelEnd(p) ? NodeType.PARALLEL_END : NodeType.NORMAL);
                    return p;
                }
            } else if (current instanceof BlockEndNode && parents.size() > 1) {
                BlockEndNode end = (BlockEndNode)current;
                FlowNode possibleOutput = this.hitParallelEnd(end, parents, blackList);
                if (possibleOutput != null) {
                    this.nextType = NodeType.PARALLEL_BRANCH_END;
                    return possibleOutput;
                }
            } else {
                throw new IllegalStateException("Found a FlowNode with multiple parents that isn't the end of a block! " + (Object)((Object)this.myCurrent));
            }
        }
        if (this.currentParallelStart != null && this.currentParallelStart.unvisited.size() > 0) {
            output = this.currentParallelStart.unvisited.pop();
            this.nextType = NodeType.PARALLEL_BRANCH_END;
        }
        if (output == null) {
            this.nextType = null;
        }
        return output;
    }

    public static void visitSimpleChunks(@Nonnull Collection<FlowNode> heads, @Nonnull Collection<FlowNode> blacklist, @Nonnull SimpleChunkVisitor visitor, @Nonnull ChunkFinder finder) {
        ForkScanner scanner = new ForkScanner();
        scanner.setup(heads, blacklist);
        scanner.visitSimpleChunks(visitor, finder);
    }

    public static void visitSimpleChunks(@Nonnull Collection<FlowNode> heads, @Nonnull SimpleChunkVisitor visitor, @Nonnull ChunkFinder finder) {
        ForkScanner scanner = new ForkScanner();
        scanner.setup(heads);
        scanner.visitSimpleChunks(visitor, finder);
    }

    public void visitSimpleChunks(@Nonnull SimpleChunkVisitor visitor, @Nonnull ChunkFinder finder) {
        FlowNode prev = null;
        if (finder.isStartInsideChunk() && this.hasNext()) {
            visitor.chunkEnd(this.myNext, null, this);
        }
        block7: while (this.hasNext()) {
            prev = this.myCurrent != this.myNext ? this.myCurrent : null;
            FlowNode f = this.next();
            boolean boundary = false;
            if (finder.isChunkStart(this.myCurrent, prev)) {
                visitor.chunkStart(this.myCurrent, this.myNext, this);
                boundary = true;
            }
            if (finder.isChunkEnd(this.myCurrent, prev)) {
                visitor.chunkEnd(this.myCurrent, prev, this);
                boundary = true;
            }
            if (!boundary) {
                visitor.atomNode(this.myNext, f, prev, this);
            }
            switch (this.currentType) {
                case NORMAL: {
                    continue block7;
                }
                case PARALLEL_END: {
                    visitor.parallelEnd(this.currentParallelStartNode, this.myCurrent, this);
                    continue block7;
                }
                case PARALLEL_START: {
                    visitor.parallelStart(this.myCurrent, prev, this);
                    continue block7;
                }
                case PARALLEL_BRANCH_END: {
                    visitor.parallelBranchEnd(this.currentParallelStartNode, this.myCurrent, this);
                    continue block7;
                }
                case PARALLEL_BRANCH_START: {
                    FlowNode parallelStart = this.nextType == NodeType.PARALLEL_START ? this.myNext : this.currentParallelStartNode;
                    visitor.parallelBranchStart(parallelStart, this.myCurrent, this);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unhandled type for current node");
        }
    }

    static class Fork
    extends ParallelBlockStart
    implements FlowPiece {
        List<FlowPiece> following = new ArrayList<FlowPiece>();

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Fork(BlockStartNode forkNode) {
            this.forkStart = forkNode;
        }
    }

    static class FlowSegment
    implements FlowPiece {
        ArrayList<FlowNode> visited = new ArrayList();
        FlowPiece after;
        boolean isLeaf = true;

        FlowSegment() {
        }

        @Override
        public boolean isLeaf() {
            return this.isLeaf;
        }

        Fork split(@Nonnull HashMap<FlowNode, FlowPiece> nodeMapping, @Nonnull BlockStartNode joinPoint, @Nonnull FlowPiece joiningBranch) {
            int index = this.visited.lastIndexOf((Object)joinPoint);
            Fork newFork = new Fork(joinPoint);
            if (index < 0) {
                throw new IllegalStateException("Tried to split a segment where the node doesn't exist in this segment");
            }
            if (index == this.visited.size() - 1) {
                newFork.following.add(this);
                newFork.following.add(joiningBranch);
                this.visited.remove(index);
            } else {
                if (index == 0) {
                    throw new IllegalStateException("We have a cyclic graph or heads that are not separate branches!");
                }
                FlowSegment newSegment = new FlowSegment();
                newSegment.after = this.after;
                newSegment.visited.addAll(this.visited.subList(0, index));
                newFork.following.add(newSegment);
                newFork.following.add(joiningBranch);
                this.after = newFork;
                this.isLeaf = false;
                this.visited.subList(0, index + 1).clear();
                for (FlowNode n : newSegment.visited) {
                    nodeMapping.put(n, newSegment);
                }
            }
            nodeMapping.put(joinPoint, newFork);
            return newFork;
        }

        public void add(FlowNode f) {
            this.visited.add(f);
        }
    }

    static interface FlowPiece {
        public boolean isLeaf();
    }

    static class ParallelBlockStart {
        BlockStartNode forkStart;
        ArrayDeque<FlowNode> unvisited = new ArrayDeque();

        ParallelBlockStart(BlockStartNode forkStart) {
            this.forkStart = forkStart;
        }

        ParallelBlockStart() {
        }
    }

    public static enum NodeType {
        NORMAL,
        PARALLEL_START,
        PARALLEL_END,
        PARALLEL_BRANCH_START,
        PARALLEL_BRANCH_END;

    }
}

