/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.graphanalysis;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import hudson.model.Action;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.Filterator;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;

public final class FlowScanningUtils {
    public static final Predicate<FlowNode> MATCH_BLOCK_START = Predicates.instanceOf(BlockStartNode.class);

    private FlowScanningUtils() {
    }

    @Nonnull
    public static Predicate<FlowNode> hasActionPredicate(final @Nonnull Class<? extends Action> actionClass) {
        return new Predicate<FlowNode>(){

            public boolean apply(FlowNode input) {
                return input != null && input.getAction(actionClass) != null;
            }
        };
    }

    @Nonnull
    public static Filterator<FlowNode> fetchEnclosingBlocks(@Nonnull FlowNode f) {
        LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
        scanner.setup(f);
        return scanner.filter(MATCH_BLOCK_START);
    }
}

