/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.org.apache.tools.tar.TarInputStream;
import hudson.util.DirScanner;
import hudson.util.io.ArchiverFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.util.BuildListenerAdapter;
import jenkins.util.VirtualFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.tar.TarEntry;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class StashManager {
    private static final String SUFFIX = ".tar.gz";

    @Deprecated
    public static void stash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes) throws IOException, InterruptedException {
        StashManager.stash(build, name, workspace, listener, includes, excludes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="fine if mkdirs returns false")
    public static void stash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull String includes, @CheckForNull String excludes, boolean useDefaultExcludes) throws IOException, InterruptedException {
        Jenkins.checkGoodName((String)name);
        File storage = StashManager.storage(build, name);
        storage.getParentFile().mkdirs();
        if (storage.isFile()) {
            listener.getLogger().println("Warning: overwriting stash \u2018" + name + "\u2019");
        }
        try (FileOutputStream os = new FileOutputStream(storage);){
            int count = workspace.archive(ArchiverFactory.TARGZ, (OutputStream)os, (DirScanner)new DirScanner.Glob(Util.fixEmpty((String)includes) == null ? "**" : includes, excludes, useDefaultExcludes));
            if (count == 0) {
                throw new AbortException("No files included in stash");
            }
            listener.getLogger().println("Stashed " + count + " file(s)");
        }
    }

    public static void unstash(@Nonnull Run<?, ?> build, @Nonnull String name, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        Jenkins.checkGoodName((String)name);
        File storage = StashManager.storage(build, name);
        if (!storage.isFile()) {
            throw new AbortException("No such saved stash \u2018" + name + "\u2019");
        }
        new FilePath(storage).untar(workspace, FilePath.TarCompression.GZIP);
    }

    public static void clearAll(@Nonnull Run<?, ?> build) throws IOException {
        Util.deleteRecursive((File)StashManager.storage(build));
    }

    public static void maybeClearAll(@Nonnull Run<?, ?> build) throws IOException {
        for (StashBehavior behavior : ExtensionList.lookup(StashBehavior.class)) {
            if (behavior.shouldClearAll(build)) continue;
            return;
        }
        StashManager.clearAll(build);
    }

    public static void copyAll(@Nonnull Run<?, ?> from, @Nonnull Run<?, ?> to) throws IOException {
        File fromStorage = StashManager.storage(from);
        if (!fromStorage.isDirectory()) {
            return;
        }
        FileUtils.copyDirectory((File)fromStorage, (File)StashManager.storage(to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={DoNotUse.class})
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="test code")
    public static Map<String, Map<String, String>> stashesOf(@Nonnull Run<?, ?> build) throws IOException {
        TreeMap<String, Map<String, String>> result = new TreeMap<String, Map<String, String>>();
        File[] kids = StashManager.storage(build).listFiles();
        if (kids != null) {
            for (File kid : kids) {
                String n = kid.getName();
                if (!n.endsWith(SUFFIX)) continue;
                TreeMap<String, String> unpacked = new TreeMap<String, String>();
                result.put(n.substring(0, n.length() - SUFFIX.length()), unpacked);
                try (FileInputStream is = new FileInputStream(kid);){
                    TarEntry te;
                    InputStream wrapped = FilePath.TarCompression.GZIP.extract((InputStream)is);
                    TarInputStream tis = new TarInputStream(wrapped);
                    while ((te = tis.getNextEntry()) != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)tis, (OutputStream)baos);
                        unpacked.put(te.getName(), baos.toString());
                    }
                }
            }
        }
        return result;
    }

    @Nonnull
    private static File storage(@Nonnull Run<?, ?> build) {
        return new File(build.getRootDir(), "stashes");
    }

    @Nonnull
    private static File storage(@Nonnull Run<?, ?> build, @Nonnull String name) {
        File dir = StashManager.storage(build);
        File f = new File(dir, name + SUFFIX);
        if (!f.getParentFile().equals(dir)) {
            throw new IllegalArgumentException();
        }
        return f;
    }

    private StashManager() {
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class CopyStashesAndArtifacts
    extends FlowCopier.ByRun {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            VirtualFile srcroot = original.getArtifactManager().root();
            FilePath dstDir = this.createTmpDir();
            try {
                HashMap<String, String> files = new HashMap<String, String>();
                for (String path : srcroot.list("**/*")) {
                    files.put(path, path);
                    InputStream in = srcroot.child(path).open();
                    try {
                        dstDir.child(path).copyFrom(in);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                if (!files.isEmpty()) {
                    listener.getLogger().println("Copying " + files.size() + " artifact(s) from " + original.getDisplayName());
                    copy.getArtifactManager().archive(dstDir, (Launcher)new Launcher.LocalLauncher(listener), (BuildListener)new BuildListenerAdapter(listener), files);
                }
            }
            finally {
                dstDir.deleteRecursive();
            }
            StashManager.copyAll(original, copy);
        }

        private FilePath createTmpDir() throws IOException {
            File dir = File.createTempFile("artifact", "copy");
            if (!dir.delete() || !dir.mkdirs()) {
                throw new IOException("Failed to create temporary directory " + dir.getPath());
            }
            return new FilePath(dir);
        }
    }

    public static abstract class StashBehavior
    implements ExtensionPoint {
        public boolean shouldClearAll(@Nonnull Run<?, ?> build) {
            return true;
        }
    }
}

