/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import hudson.model.Queue;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;

public abstract class FlowExecutionOwner
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(FlowExecutionOwner.class.getName());

    @Nonnull
    public abstract FlowExecution get() throws IOException;

    @CheckForNull
    public FlowExecution getOrNull() {
        try {
            return this.get();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            return null;
        }
    }

    public abstract File getRootDir() throws IOException;

    public abstract Queue.Executable getExecutable() throws IOException;

    public abstract String getUrl() throws IOException;

    public String getUrlOfExecution() throws IOException {
        return this.getUrl() + "execution/";
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Nonnull
    public TaskListener getListener() throws IOException {
        return TaskListener.NULL;
    }

    public static FlowExecutionOwner dummyOwner() {
        return new DummyOwner();
    }

    private static class DummyOwner
    extends FlowExecutionOwner {
        DummyOwner() {
        }

        @Override
        public FlowExecution get() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public File getRootDir() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public Queue.Executable getExecutable() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public String getUrl() throws IOException {
            throw new IOException("not implemented");
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof DummyOwner;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    public static interface Executable
    extends Queue.Executable {
        @CheckForNull
        public FlowExecutionOwner asFlowExecutionOwner();
    }
}

