/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.init.Terminator;
import hudson.model.listeners.ItemListener;
import hudson.remoting.SingleLaneExecutorService;
import hudson.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.StepExecutionIterator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Extension
public class FlowExecutionList
implements Iterable<FlowExecution> {
    private CopyOnWriteList<FlowExecutionOwner> runningTasks = new CopyOnWriteList();
    private final SingleLaneExecutorService executor = new SingleLaneExecutorService((ExecutorService)Timer.get());
    private XmlFile configFile;
    private static final Logger LOGGER = Logger.getLogger(FlowExecutionList.class.getName());

    public FlowExecutionList() {
        this.load();
    }

    @Override
    public Iterator<FlowExecution> iterator() {
        return new AbstractIterator<FlowExecution>(){
            final Iterator<FlowExecutionOwner> base;
            {
                this.base = FlowExecutionList.this.runningTasks.iterator();
            }

            protected FlowExecution computeNext() {
                while (this.base.hasNext()) {
                    FlowExecutionOwner o = this.base.next();
                    try {
                        FlowExecution e = o.get();
                        if (e.isComplete()) {
                            FlowExecutionList.this.unregister(o);
                            continue;
                        }
                        return e;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to load " + o + ". Unregistering", e);
                        FlowExecutionList.this.unregister(o);
                    }
                }
                return (FlowExecution)this.endOfData();
            }
        };
    }

    @CheckForNull
    private synchronized XmlFile configFile() {
        Jenkins j;
        if (this.configFile == null && (j = Jenkins.getInstance()) != null) {
            this.configFile = new XmlFile(new File(j.getRootDir(), FlowExecutionList.class.getName() + ".xml"));
        }
        return this.configFile;
    }

    private synchronized void load() {
        XmlFile cf = this.configFile();
        if (cf == null) {
            return;
        }
        if (cf.exists()) {
            try {
                this.runningTasks.replaceBy((Collection)((List)cf.read()));
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    public synchronized void register(FlowExecutionOwner self) {
        this.load();
        if (!this.runningTasks.contains((Object)self)) {
            this.runningTasks.add((Object)self);
        }
        this.saveLater();
    }

    public synchronized void unregister(FlowExecutionOwner self) {
        this.load();
        this.runningTasks.remove((Object)self);
        LOGGER.log(Level.FINE, "unregistered {0} so is now {1}", new Object[]{self, this.runningTasks.getView()});
        this.saveLater();
    }

    private synchronized void saveLater() {
        final ArrayList<FlowExecutionOwner> copy = new ArrayList<FlowExecutionOwner>(this.runningTasks.getView());
        try {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    FlowExecutionList.this.save(copy);
                }
            });
        }
        catch (RejectedExecutionException x) {
            LOGGER.log(Level.FINE, "could not schedule save, perhaps because Jenkins is shutting down; saving immediately", x);
            this.save(copy);
        }
    }

    private void save(List<FlowExecutionOwner> copy) {
        XmlFile cf = this.configFile();
        LOGGER.log(Level.FINE, "saving {0} to {1}", new Object[]{copy, cf});
        if (cf == null) {
            return;
        }
        try {
            cf.write(copy);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    public static FlowExecutionList get() {
        FlowExecutionList l = (FlowExecutionList)ExtensionList.lookup(FlowExecutionList.class).get(FlowExecutionList.class);
        if (l == null) {
            l = new FlowExecutionList();
        }
        return l;
    }

    @Terminator
    @Restricted(value={DoNotUse.class})
    public static void saveAll() throws InterruptedException {
        LOGGER.fine("ensuring all executions are saved");
        SingleLaneExecutorService executor = FlowExecutionList.get().executor;
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Extension
    public static class StepExecutionIteratorImpl
    extends StepExecutionIterator {
        @Inject
        FlowExecutionList list;

        public ListenableFuture<?> apply(final Function<StepExecution, Void> f) {
            ArrayList<ListenableFuture<List<StepExecution>>> all = new ArrayList<ListenableFuture<List<StepExecution>>>();
            for (FlowExecution e : this.list) {
                ListenableFuture<List<StepExecution>> execs = e.getCurrentExecutions(false);
                all.add(execs);
                Futures.addCallback(execs, (FutureCallback)new FutureCallback<List<StepExecution>>(){

                    public void onSuccess(List<StepExecution> result) {
                        for (StepExecution e : result) {
                            try {
                                f.apply((Object)e);
                            }
                            catch (RuntimeException x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                        }
                    }

                    public void onFailure(Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                });
            }
            return Futures.allAsList(all);
        }
    }

    @Extension
    public static class ItemListenerImpl
    extends ItemListener {
        @Inject
        FlowExecutionList list;

        public void onLoaded() {
            for (final FlowExecution e : this.list) {
                LOGGER.log(Level.FINE, "Eager loading {0}", e);
                Futures.addCallback(e.getCurrentExecutions(false), (FutureCallback)new FutureCallback<List<StepExecution>>(){

                    public void onSuccess(List<StepExecution> result) {
                        LOGGER.log(Level.FINE, "Will resume {0}", result);
                        for (StepExecution se : result) {
                            se.onResume();
                        }
                    }

                    public void onFailure(Throwable t) {
                        if (t instanceof CancellationException) {
                            LOGGER.log(Level.FINE, "Cancelled load of " + e, t);
                        } else {
                            LOGGER.log(Level.WARNING, "Failed to load " + e, t);
                        }
                    }
                });
            }
        }
    }
}

