/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.flow;

import com.google.common.util.concurrent.ListenableFuture;
import hudson.Util;
import hudson.model.Result;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowActionStorage;
import org.jenkinsci.plugins.workflow.graph.FlowEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public abstract class FlowExecution
implements FlowActionStorage {
    public abstract void start() throws IOException;

    public void onLoad(FlowExecutionOwner owner) throws IOException {
        if (Util.isOverridden(FlowExecution.class, this.getClass(), (String)"onLoad", (Class[])new Class[0])) {
            this.onLoad();
        }
    }

    @Deprecated
    public void onLoad() {
        throw new AbstractMethodError("you must implement the new overload of onLoad");
    }

    public abstract FlowExecutionOwner getOwner();

    public abstract List<FlowNode> getCurrentHeads();

    public ListenableFuture<List<StepExecution>> getCurrentExecutions(boolean innerMostOnly) {
        if (Util.isOverridden(FlowExecution.class, this.getClass(), (String)"getCurrentExecutions", (Class[])new Class[0]) && innerMostOnly) {
            return this.getCurrentExecutions();
        }
        throw new AbstractMethodError("you must implement the new overload of getCurrentExecutions");
    }

    @Deprecated
    public ListenableFuture<List<StepExecution>> getCurrentExecutions() {
        throw new AbstractMethodError("you must implement the new overload of getCurrentExecutions");
    }

    public abstract boolean isCurrentHead(FlowNode var1);

    public String getUrl() throws IOException {
        return this.getOwner().getUrlOfExecution();
    }

    public abstract void interrupt(Result var1, CauseOfInterruption ... var2) throws IOException, InterruptedException;

    public abstract void addListener(GraphListener var1);

    public void removeListener(GraphListener listener) {
    }

    public boolean isComplete() {
        List<FlowNode> heads = this.getCurrentHeads();
        return heads.size() == 1 && heads.get(0) instanceof FlowEndNode;
    }

    public boolean blocksRestart() {
        return true;
    }

    @CheckForNull
    public final Throwable getCauseOfFailure() {
        List<FlowNode> heads = this.getCurrentHeads();
        if (heads.size() != 1 || !(heads.get(0) instanceof FlowEndNode)) {
            return null;
        }
        FlowNode e = heads.get(0);
        ErrorAction error = e.getPersistentAction(ErrorAction.class);
        if (error == null) {
            return null;
        }
        return error.getError();
    }

    @CheckForNull
    public abstract FlowNode getNode(String var1) throws IOException;

    @Nonnull
    public abstract Authentication getAuthentication();
}

