/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecutionIterator;

public abstract class StepExecution
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(StepExecution.class.getName());
    @Inject
    private StepContext context;
    private static final long serialVersionUID = 1L;

    @Deprecated
    protected StepExecution() {
    }

    protected StepExecution(@Nonnull StepContext context) {
        this.context = context;
    }

    @Nonnull
    public StepContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("you must either pass in a StepContext to the StepExecution constructor, or have the StepExecution be created automatically");
        }
        return this.context;
    }

    public abstract boolean start() throws Exception;

    public abstract void stop(@Nonnull Throwable var1) throws Exception;

    public void onResume() {
    }

    @CheckForNull
    public String getStatus() {
        return null;
    }

    @CheckForNull
    public final String getStatusBounded(long timeout, TimeUnit unit) {
        Future<String> task = null;
        try {
            task = Timer.get().submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return StepExecution.this.getStatus();
                }
            });
            return task.get(timeout, unit);
        }
        catch (Exception x) {
            if (task != null) {
                task.cancel(true);
            }
            LOGGER.log(Level.FINE, "failed to check status of " + super.toString(), x);
            return x.toString();
        }
    }

    public static ListenableFuture<?> applyAll(Function<StepExecution, Void> f) {
        ArrayList futures = new ArrayList();
        for (StepExecutionIterator i : StepExecutionIterator.all()) {
            futures.add(i.apply(f));
        }
        return Futures.allAsList(futures);
    }

    public static <T extends StepExecution> ListenableFuture<?> applyAll(final Class<T> type, final Function<T, Void> f) {
        return StepExecution.applyAll(new Function<StepExecution, Void>(){

            public Void apply(StepExecution e) {
                if (type.isInstance(e)) {
                    f.apply(type.cast(e));
                }
                return null;
            }
        });
    }
}

