/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class MissingContextVariableException
extends Exception {
    @Nonnull
    private final Class<?> type;
    private static final long serialVersionUID = 1L;

    public MissingContextVariableException(@Nonnull Class<?> type) {
        super("Required context " + type + " is missing");
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Nonnull
    public List<StepDescriptor> getProviders() {
        ArrayList<StepDescriptor> r = new ArrayList<StepDescriptor>();
        for (StepDescriptor sd : StepDescriptor.all()) {
            if (!this.isIn(sd.getProvidedContext()) || this.isIn(sd.getRequiredContext())) continue;
            r.add(sd);
        }
        return r;
    }

    private boolean isIn(Set<? extends Class<?>> classes) {
        for (Class<?> t : classes) {
            if (!this.type.isAssignableFrom(t)) continue;
            return true;
        }
        return false;
    }
}

