/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import hudson.slaves.WorkspaceList;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.LibraryRetrieverDescriptor;
import org.jenkinsci.plugins.workflow.steps.scm.GenericSCMStep;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class SCMSourceRetriever
extends LibraryRetriever {
    private final SCMSource scm;

    @DataBoundConstructor
    public SCMSourceRetriever(SCMSource scm) {
        this.scm = scm;
    }

    public SCMSource getScm() {
        return this.scm;
    }

    @Override
    public void retrieve(String name, String version, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
        SCMRevision revision = this.scm.fetch(version, listener);
        if (revision == null) {
            throw new AbortException("No version " + version + " found for library " + name);
        }
        SCMSourceRetriever.doRetrieve(this.scm.build(revision.getHead(), revision), target, run, listener);
    }

    static void doRetrieve(@Nonnull SCM scm, FilePath target, Run<?, ?> run, TaskListener listener) throws Exception {
        FilePath baseWorkspace;
        GenericSCMStep delegate = new GenericSCMStep(scm);
        delegate.setPoll(false);
        delegate.setChangelog(true);
        Jenkins node = Jenkins.getActiveInstance();
        if (run.getParent() instanceof TopLevelItem) {
            baseWorkspace = node.getWorkspaceFor((TopLevelItem)run.getParent());
            if (baseWorkspace == null) {
                throw new IOException(node.getDisplayName() + " may be offline");
            }
        } else {
            throw new AbortException("Cannot check out in non-top-level build");
        }
        FilePath dir = baseWorkspace.withSuffix(SCMSourceRetriever.getFilePathSuffix() + "libs");
        Computer computer = node.toComputer();
        if (computer == null) {
            throw new IOException(node.getDisplayName() + " may be offline");
        }
        try (WorkspaceList.Lease lease = computer.getWorkspaceList().acquire(dir);){
            delegate.checkout(run, dir, listener, node.createLauncher(listener));
            dir.copyRecursiveTo("src/**/*.groovy,vars/*.groovy,vars/*.txt,resources/", null, target);
        }
    }

    private static String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    @Override
    public FormValidation validateVersion(String name, String version) {
        StringWriter w = new StringWriter();
        try {
            StreamTaskListener listener = new StreamTaskListener((Writer)w);
            SCMRevision revision = this.scm.fetch(version, (TaskListener)listener);
            if (revision != null) {
                return FormValidation.ok((String)("Currently maps to revision: " + revision));
            }
            listener.getLogger().flush();
            return FormValidation.warning((String)("Revision seems invalid:\n" + w));
        }
        catch (Exception x) {
            return FormValidation.warning((Throwable)x, (String)"Cannot validate default version.");
        }
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    public static class Hider
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            if (descriptor instanceof DescriptorImpl) {
                return !((DescriptorImpl)descriptor).getSCMDescriptors().isEmpty();
            }
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends LibraryRetrieverDescriptor {
        public String getDisplayName() {
            return "Modern SCM";
        }

        @Restricted(value={NoExternalUse.class})
        public Collection<SCMSourceDescriptor> getSCMDescriptors() {
            ArrayList<SCMSourceDescriptor> descriptors = new ArrayList<SCMSourceDescriptor>();
            for (SCMSourceDescriptor d : ExtensionList.lookup(SCMSourceDescriptor.class)) {
                if (!Util.isOverridden(SCMSource.class, (Class)d.clazz, (String)"retrieve", (Class[])new Class[]{String.class, TaskListener.class})) continue;
                descriptors.add(d);
            }
            return descriptors;
        }
    }
}

