/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.GlobalVariableSet;
import org.jenkinsci.plugins.workflow.cps.global.UserDefinedGlobalVariable;
import org.jenkinsci.plugins.workflow.cps.replay.OriginalLoadedScripts;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.flow.FlowCopier;
import org.jenkinsci.plugins.workflow.libs.ClasspathAdder;
import org.jenkinsci.plugins.workflow.libs.LibrariesAction;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryRecord;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;

@Extension
public class LibraryAdder
extends ClasspathAdder {
    private static final Logger LOGGER = Logger.getLogger(LibraryAdder.class.getName());

    @Override
    public List<ClasspathAdder.Addition> add(CpsFlowExecution execution, List<String> libraries) throws Exception {
        Queue.Executable executable = execution.getOwner().getExecutable();
        if (!(executable instanceof Run)) {
            return Collections.emptyList();
        }
        Run build = (Run)executable;
        HashMap<String, String> libraryVersions = new HashMap<String, String>();
        HashMap<Object, String> librariesUnparsed = new HashMap<Object, String>();
        for (String library : libraries) {
            String[] parsed = LibraryAdder.parse(library);
            libraryVersions.put(parsed[0], parsed[1]);
            librariesUnparsed.put(parsed[0], library);
        }
        ArrayList<ClasspathAdder.Addition> additions = new ArrayList<ClasspathAdder.Addition>();
        LibrariesAction action = (LibrariesAction)build.getAction(LibrariesAction.class);
        if (action != null) {
            for (LibraryRecord record : action.getLibraries()) {
                FilePath libDir = new FilePath(execution.getOwner().getRootDir()).child("libs/" + record.name);
                for (String root : new String[]{"src", "vars"}) {
                    FilePath dir = libDir.child(root);
                    if (!dir.isDirectory()) continue;
                    additions.add(new ClasspathAdder.Addition(dir.toURI().toURL(), record.trusted));
                }
                String unparsed = (String)librariesUnparsed.get(record.name);
                if (unparsed == null) continue;
                libraries.remove(unparsed);
            }
            return additions;
        }
        LinkedHashMap<String, LibraryRecord> librariesAdded = new LinkedHashMap<String, LibraryRecord>();
        HashMap<String, LibraryRetriever> retrievers = new HashMap<String, LibraryRetriever>();
        TaskListener listener = execution.getOwner().getListener();
        for (LibraryResolver kind : ExtensionList.lookup(LibraryResolver.class)) {
            boolean kindTrusted = kind.isTrusted();
            for (LibraryConfiguration cfg : kind.forJob(build.getParent(), libraryVersions)) {
                String name = cfg.getName();
                if (!cfg.isImplicit() && !libraryVersions.containsKey(name)) continue;
                if (librariesAdded.containsKey(name)) {
                    listener.getLogger().println("Only using first definition of library " + name);
                    continue;
                }
                String version = cfg.defaultedVersion((String)libraryVersions.remove(name));
                librariesAdded.put(name, new LibraryRecord(name, version, kindTrusted));
                retrievers.put(name, cfg.getRetriever());
            }
        }
        for (String name : librariesAdded.keySet()) {
            String unparsed = (String)librariesUnparsed.get(name);
            if (unparsed == null) continue;
            libraries.remove(unparsed);
        }
        build.addAction((Action)new LibrariesAction(new ArrayList<LibraryRecord>(librariesAdded.values())));
        for (LibraryRecord record : librariesAdded.values()) {
            listener.getLogger().println("Loading library " + record.name + "@" + record.version);
            for (URL u : LibraryAdder.retrieve(record.name, record.version, (LibraryRetriever)((Object)retrievers.get(record.name)), record.trusted, listener, build, execution, record.variables)) {
                additions.add(new ClasspathAdder.Addition(u, record.trusted));
            }
        }
        return additions;
    }

    @Nonnull
    private static String[] parse(@Nonnull String identifier) {
        int at = identifier.indexOf(64);
        if (at == -1) {
            return new String[]{identifier, null};
        }
        return new String[]{identifier.substring(0, at), identifier.substring(at + 1)};
    }

    private static List<URL> retrieve(@Nonnull String name, @Nonnull String version, @Nonnull LibraryRetriever retriever, boolean trusted, @Nonnull TaskListener listener, @Nonnull Run<?, ?> run, @Nonnull CpsFlowExecution execution, @Nonnull Set<String> variables) throws Exception {
        FilePath varsDir;
        FilePath libDir = new FilePath(execution.getOwner().getRootDir()).child("libs/" + name);
        retriever.retrieve(name, version, libDir, run, listener);
        if (!trusted) {
            for (String clazz : ReplayAction.replacementsIn((CpsFlowExecution)execution)) {
                for (String root : new String[]{"src", "vars"}) {
                    String replacement;
                    String rel = root + "/" + clazz.replace('.', '/') + ".groovy";
                    FilePath f = libDir.child(rel);
                    if (!f.exists() || (replacement = ReplayAction.replace((CpsFlowExecution)execution, (String)clazz)) == null) continue;
                    listener.getLogger().println("Replacing contents of " + rel);
                    f.write(replacement, null);
                }
            }
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        FilePath srcDir = libDir.child("src");
        if (srcDir.isDirectory()) {
            urls.add(srcDir.toURI().toURL());
        }
        if ((varsDir = libDir.child("vars")).isDirectory()) {
            urls.add(varsDir.toURI().toURL());
            for (FilePath var : varsDir.list("*.groovy")) {
                variables.add(var.getBaseName());
            }
        }
        if (urls.isEmpty()) {
            throw new AbortException("Library " + name + " expected to contain at least one of src or vars directories");
        }
        return urls;
    }

    @Nonnull
    static Map<String, String> findResources(@Nonnull CpsFlowExecution execution, @Nonnull String name) throws IOException, InterruptedException {
        Run run;
        LibrariesAction action;
        TreeMap<String, String> resources = new TreeMap<String, String>();
        Queue.Executable executable = execution.getOwner().getExecutable();
        if (executable instanceof Run && (action = (LibrariesAction)(run = (Run)executable).getAction(LibrariesAction.class)) != null) {
            FilePath libs = new FilePath(run.getRootDir()).child("libs");
            for (LibraryRecord library : action.getLibraries()) {
                FilePath f = libs.child(library.name + "/resources/" + name);
                if (!f.exists()) continue;
                resources.put(library.name, f.readToString());
            }
        }
        return resources;
    }

    @Extension
    public static class Copier
    extends FlowCopier.ByRun {
        public void copy(Run<?, ?> original, Run<?, ?> copy, TaskListener listener) throws IOException, InterruptedException {
            LibrariesAction action = (LibrariesAction)original.getAction(LibrariesAction.class);
            if (action != null) {
                copy.addAction((Action)new LibrariesAction(action.getLibraries()));
                FilePath libs = new FilePath(original.getRootDir()).child("libs");
                if (libs.isDirectory()) {
                    libs.copyRecursiveTo(new FilePath(copy.getRootDir()).child("libs"));
                }
            }
        }
    }

    @Extension
    public static class LoadedLibraries
    extends OriginalLoadedScripts {
        public Map<String, String> loadScripts(CpsFlowExecution execution) {
            HashMap<String, String> scripts = new HashMap<String, String>();
            try {
                Run run;
                LibrariesAction action;
                Queue.Executable executable = execution.getOwner().getExecutable();
                if (executable instanceof Run && (action = (LibrariesAction)(run = (Run)executable).getAction(LibrariesAction.class)) != null) {
                    FilePath libs = new FilePath(run.getRootDir()).child("libs");
                    for (LibraryRecord library : action.getLibraries()) {
                        if (library.trusted) continue;
                        for (String rootName : new String[]{"src", "vars"}) {
                            FilePath root = libs.child(library.name + "/" + rootName);
                            if (!root.isDirectory()) continue;
                            for (FilePath groovy : root.list("**/*.groovy")) {
                                String clazz = groovy.getRemote().replaceFirst("^\\Q" + root.getRemote() + "\\E[/\\\\](.+)[.]groovy", "$1").replace('/', '.');
                                scripts.put(clazz, groovy.readToString());
                            }
                        }
                    }
                }
            }
            catch (IOException | InterruptedException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
            return scripts;
        }
    }

    @Extension
    public static class GlobalVars
    extends GlobalVariableSet {
        public Collection<GlobalVariable> forRun(Run<?, ?> run) {
            if (run == null) {
                return Collections.emptySet();
            }
            LibrariesAction action = (LibrariesAction)run.getAction(LibrariesAction.class);
            if (action == null) {
                return Collections.emptySet();
            }
            ArrayList<GlobalVariable> vars = new ArrayList<GlobalVariable>();
            for (LibraryRecord library : action.getLibraries()) {
                for (String variable : library.variables) {
                    vars.add(new UserDefinedGlobalVariable(variable, new File(run.getRootDir(), "libs/" + library.name + "/vars/" + variable + ".txt")));
                }
            }
            return vars;
        }
    }
}

