/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.libs;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class FolderLibraries
extends AbstractFolderProperty<AbstractFolder<?>> {
    private final List<LibraryConfiguration> libraries;

    @DataBoundConstructor
    public FolderLibraries(List<LibraryConfiguration> libraries) {
        this.libraries = libraries;
    }

    public List<LibraryConfiguration> getLibraries() {
        return this.libraries;
    }

    @Extension(ordinal=100.0)
    public static class ForJob
    extends LibraryResolver {
        @Override
        public boolean isTrusted() {
            return false;
        }

        @Override
        public Collection<LibraryConfiguration> forJob(Job<?, ?> job, Map<String, String> libraryVersions) {
            ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
            ItemGroup group = job.getParent();
            while (group instanceof AbstractFolder) {
                FolderLibraries prop = (FolderLibraries)((AbstractFolder)group).getProperties().get(FolderLibraries.class);
                if (prop != null) {
                    libraries.addAll(prop.getLibraries());
                }
                group = ((AbstractFolder)group).getParent();
            }
            return libraries;
        }

        @Override
        public Collection<LibraryConfiguration> fromConfiguration(StaplerRequest request) {
            ArrayList<LibraryConfiguration> libraries = new ArrayList<LibraryConfiguration>();
            ItemGroup group = (ItemGroup)request.findAncestorObject(AbstractFolder.class);
            while (group instanceof AbstractFolder) {
                FolderLibraries prop = (FolderLibraries)((AbstractFolder)group).getProperties().get(FolderLibraries.class);
                if (prop != null) {
                    libraries.addAll(prop.getLibraries());
                }
                group = ((AbstractFolder)group).getParent();
            }
            return libraries;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor {
        public AbstractFolderProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            FolderLibraries prop = (FolderLibraries)super.newInstance(req, formData);
            return prop.libraries.isEmpty() ? null : prop;
        }
    }
}

