/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;

class PullRequestSCMRevision
extends SCMRevision {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String baseHash;
    @NonNull
    private final String pullHash;

    PullRequestSCMRevision(@NonNull PullRequestSCMHead head, @NonNull String baseHash, @NonNull String pullHash) {
        super((SCMHead)head);
        this.baseHash = baseHash;
        this.pullHash = pullHash;
    }

    @NonNull
    public String getBaseHash() {
        return this.baseHash;
    }

    @NonNull
    public String getPullHash() {
        return this.pullHash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PullRequestSCMRevision)) {
            return false;
        }
        PullRequestSCMRevision other = (PullRequestSCMRevision)((Object)o);
        return this.getHead().equals((Object)other.getHead()) && this.baseHash.equals(other.baseHash) && this.pullHash.equals(other.pullHash);
    }

    public int hashCode() {
        return this.pullHash.hashCode();
    }

    public String toString() {
        return this.getHead() instanceof PullRequestSCMHead && ((PullRequestSCMHead)this.getHead()).isMerge() ? this.pullHash + "+" + this.baseHash : this.pullHash;
    }
}

