/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import hudson.model.Action;
import java.util.LinkedList;
import java.util.List;
import jenkins.scm.api.SCMHead;
import org.jenkinsci.plugins.github_branch_source.PullRequestAction;
import org.kohsuke.github.GHPullRequest;

public final class PullRequestSCMHead
extends SCMHead {
    private static final long serialVersionUID = 1L;
    private final PullRequestAction metadata;
    private Boolean merge;
    private final boolean trusted;

    PullRequestSCMHead(GHPullRequest pr, String name, boolean merge, boolean trusted) {
        super(name);
        this.metadata = new PullRequestAction(pr);
        this.merge = merge;
        this.trusted = trusted;
    }

    public int getNumber() {
        if (this.metadata != null) {
            return Integer.parseInt(this.metadata.getId());
        }
        return Integer.parseInt(this.getName().substring("PR-".length()));
    }

    private Object readResolve() {
        if (this.merge == null) {
            this.merge = true;
        }
        return this;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public List<? extends Action> getAllActions() {
        LinkedList<PullRequestAction> actions = new LinkedList<PullRequestAction>(super.getAllActions());
        actions.add(this.metadata);
        return actions;
    }
}

