/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.github_branch_source;

import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Job;
import hudson.security.ACL;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.util.Timer;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.kohsuke.github.GHEvent;

@Extension
public class PullRequestGHEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOGGER = Logger.getLogger(PullRequestGHEventSubscriber.class.getName());
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)");

    protected boolean isApplicable(@Nullable Job<?, ?> project) {
        if (project != null && project.getParent() instanceof SCMSourceOwner) {
            SCMSourceOwner owner = (SCMSourceOwner)project.getParent();
            for (SCMSource source : owner.getSCMSources()) {
                if (!(source instanceof GitHubSCMSource)) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PULL_REQUEST, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        String repoUrl = json.getJSONObject("repository").getString("html_url");
        LOGGER.log(Level.FINE, "Received POST for {0}", repoUrl);
        Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repoUrl);
        if (matcher.matches()) {
            final GitHubRepositoryName changedRepository = GitHubRepositoryName.create((String)repoUrl);
            if (changedRepository == null) {
                LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
                return;
            }
            Timer.get().schedule(new Runnable(){

                @Override
                public void run() {
                    ACL.impersonate((Authentication)ACL.SYSTEM, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean found = false;
                            for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                                for (SCMSource source : owner.getSCMSources()) {
                                    GitHubSCMSource gitHubSCMSource;
                                    if (!(source instanceof GitHubSCMSource) || !(gitHubSCMSource = (GitHubSCMSource)source).getRepoOwner().equals(changedRepository.getUserName()) || !gitHubSCMSource.getRepository().equals(changedRepository.getRepositoryName())) continue;
                                    owner.onSCMSourceUpdated((SCMSource)gitHubSCMSource);
                                    LOGGER.log(Level.FINE, "PR event on {0}:{1}/{2} forwarded to {3}", new Object[]{changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName(), owner.getFullName()});
                                    found = true;
                                }
                            }
                            if (!found) {
                                LOGGER.log(Level.FINE, "PR event on {0}:{1}/{2} did not match any project", new Object[]{changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName()});
                            }
                        }
                    });
                }
            }, 5L, TimeUnit.SECONDS);
        } else {
            LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
        }
    }
}

